/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.config;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class IncElasticsearchConfiguration
implements FactoryBean<RestHighLevelClient>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(IncElasticsearchConfiguration.class);
    @Value(value="${es.cluster.address}")
    private String clusterNodes;
    @Value(value="${es.source}")
    private String esSource;
    @Value(value="${es.client.username}")
    private String esClientUsername;
    @Value(value="${es.client.password}")
    private String esClientPassword;
    @Value(value="${es.pool.maxTotal}")
    private int maxTotal;
    @Value(value="${es.pool.connectionTimeout}")
    private int connectionTimeout;
    @Value(value="${es.pool.socketTimeout}")
    private int socketTimeout;
    @Value(value="${es.pool.maxRetryTimeoutMillis}")
    private int maxRetryTimeoutMillis;
    @Value(value="${es.pool.connectionRequestTimeout}")
    private int connectionRequestTimeout;
    private RestHighLevelClient restHighLevelClient;

    public RestHighLevelClient getObject() throws Exception {
        return this.restHighLevelClient;
    }

    public Class<?> getObjectType() {
        return RestHighLevelClient.class;
    }

    public void destroy() {
        try {
            if (this.restHighLevelClient != null) {
                this.restHighLevelClient.close();
            }
        }
        catch (Exception e) {
            log.error("Error closing ElasticSearch client: ", (Throwable)e);
        }
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() {
        this.restHighLevelClient = this.buildClient();
    }

    private RestHighLevelClient buildClient() {
        RestClientBuilder clientBuilder = null;
        try {
            if (StringUtils.isEmpty((Object)this.clusterNodes)) {
                return null;
            }
            ArrayList<String> ipAdrrs = new ArrayList<String>(Arrays.asList(this.clusterNodes.split(",")));
            HttpHost httpHost = null;
            HttpHost[] httpHosts = new HttpHost[ipAdrrs.size()];
            for (int i = 0; i < ipAdrrs.size(); ++i) {
                httpHosts[i] = httpHost = new HttpHost(((String)ipAdrrs.get(i)).split(":")[0], Integer.valueOf(((String)ipAdrrs.get(i)).split(":")[1]).intValue(), "http");
            }
            clientBuilder = RestClient.builder((HttpHost[])httpHosts);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != clientBuilder) {
            clientBuilder.setFailureListener(new RestClient.FailureListener(){

                public void onFailure(HttpHost host) {
                    super.onFailure(new Node(host));
                    System.out.println(host.getHostName() + "==\u8282\u70b9\u5931\u8d25\u4e86");
                }
            });
        }
        if (null != clientBuilder) {
            clientBuilder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                    return httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(IncElasticsearchConfiguration.this.maxTotal).build());
                }
            });
        }
        if (null != clientBuilder) {
            clientBuilder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

                public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                    return requestConfigBuilder.setConnectTimeout(IncElasticsearchConfiguration.this.connectionTimeout).setSocketTimeout(IncElasticsearchConfiguration.this.socketTimeout).setConnectionRequestTimeout(IncElasticsearchConfiguration.this.connectionRequestTimeout);
                }
            });
        }
        if ("AliYun".equals(this.esSource)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.esClientUsername, this.esClientPassword));
            if (null != clientBuilder) {
                clientBuilder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                    final /* synthetic */ CredentialsProvider val$credentialsProvider;
                    {
                        this.val$credentialsProvider = credentialsProvider;
                    }

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                        return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                    }
                });
            }
        }
        this.restHighLevelClient = new RestHighLevelClient(clientBuilder);
        return this.restHighLevelClient;
    }
}

