/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.model.rule.impl;

import com.tydic.dyc.inc.model.rule.IncRuleChngStatusDO;
import com.tydic.dyc.inc.model.rule.IncRuleDO;
import com.tydic.dyc.inc.model.rule.IncRuleItemDO;
import com.tydic.dyc.inc.model.rule.IncRuleModel;
import com.tydic.dyc.inc.model.rule.qrybo.IncRuleListQryBO;
import com.tydic.dyc.inc.model.rule.qrybo.IncRuleQryBO;
import com.tydic.dyc.inc.model.rule.qrybo.IncRuleQryRspBO;
import com.tydic.dyc.inc.model.rule.sub.IncCheckRuleApp;
import com.tydic.dyc.inc.model.rule.sub.IncConfRule;
import com.tydic.dyc.inc.model.rule.sub.IncConfRuleApp;
import com.tydic.dyc.inc.model.rule.sub.IncConfRuleDivisor;
import com.tydic.dyc.inc.model.rule.sub.IncConfRuleGroup;
import com.tydic.dyc.inc.model.rule.sub.IncConfRuleItem;
import com.tydic.dyc.inc.model.rule.sub.IncRuleList;
import com.tydic.dyc.inc.repository.IncConfRuleRepository;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncConfRuleAppScopeBo;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncConfRuleDivisorBo;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncConfRuleGroupBo;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncConfRuleItemBo;
import com.tydic.dyc.inc.utils.IdUtil;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IncRuleModelImpl
implements IncRuleModel {
    @Autowired
    private IncConfRuleRepository incConfRuleRepository;

    @Override
    public void addRule(IncRuleDO incRuleDO) {
        IncConfRule incConfRule = IncRu.js(incRuleDO, IncConfRule.class);
        incConfRule.setConfId(IdUtil.nextId());
        incConfRule.setDelTag(IncConstants.DELETE_TAG.NO_DEL);
        this.incConfRuleRepository.addConfRule(incConfRule);
        this.addRuleOtherInfo(incRuleDO, incConfRule.getConfId());
    }

    @Override
    public IncRuleDO qryRuleDetail(IncRuleQryBO incRuleQryBO) {
        IncRuleDO incRuleDO = this.incConfRuleRepository.qryRuleDetail(incRuleQryBO);
        List<IncConfRuleApp> incConfRuleApps = this.incConfRuleRepository.qryRuleAppByConfId(incRuleQryBO);
        ArrayList<IncConfRuleAppScopeBo> ruleAppScopeBos = new ArrayList<IncConfRuleAppScopeBo>();
        incConfRuleApps.forEach(app -> {
            IncConfRuleAppScopeBo incConfRuleAppScopeBo = new IncConfRuleAppScopeBo();
            incConfRuleAppScopeBo.setRuleOrgId(app.getOrgId());
            incConfRuleAppScopeBo.setRuleOrgName(app.getOrgName());
            ruleAppScopeBos.add(incConfRuleAppScopeBo);
        });
        incRuleDO.setRuleAppScopes(ruleAppScopeBos);
        List<IncConfRuleItem> incConfRuleItems = this.incConfRuleRepository.qryRuleItemByConfId(incRuleQryBO);
        if (!CollectionUtils.isEmpty(incConfRuleItems)) {
            List<IncConfRuleItemBo> incConfRuleItemBos = IncRu.jsl(incConfRuleItems, IncConfRuleItemBo.class);
            List<IncConfRuleGroup> incConfRuleGroups = this.incConfRuleRepository.qryRuleGroupByConfId(incRuleQryBO);
            List<IncConfRuleGroupBo> incConfRuleGroupBos = IncRu.jsl(incConfRuleGroups, IncConfRuleGroupBo.class);
            if (!CollectionUtils.isEmpty(incConfRuleGroupBos)) {
                List<IncConfRuleDivisor> incConfRuleDivisors = this.incConfRuleRepository.qryRuleDivisorByConfId(incRuleQryBO);
                Map<Long, List<IncConfRuleDivisor>> ruleDivisorMap = incConfRuleDivisors.stream().collect(Collectors.groupingBy(IncConfRuleDivisor::getGroupId));
                incConfRuleGroupBos.forEach(groupItem -> {
                    if (ruleDivisorMap.containsKey(groupItem.getGroupId())) {
                        groupItem.setRuleDivisorBos(IncRu.jsl((List)ruleDivisorMap.get(groupItem.getGroupId()), IncConfRuleDivisorBo.class));
                    }
                });
            }
            Map<Long, List<IncConfRuleGroupBo>> ruleGroupMap = incConfRuleGroupBos.stream().collect(Collectors.groupingBy(IncConfRuleGroupBo::getRuleId));
            incConfRuleItemBos.forEach(ruleItem -> {
                if (ruleGroupMap.containsKey(ruleItem.getRuleId())) {
                    ruleItem.setRuleGroupBos(IncRu.jsl((List)ruleGroupMap.get(ruleItem.getRuleId()), IncConfRuleGroupBo.class));
                }
            });
            incRuleDO.setRuleItemBos(incConfRuleItemBos);
        }
        return incRuleDO;
    }

    @Override
    public IncRuleQryRspBO qryRuleListPage(IncRuleListQryBO incRuleListQryBO) {
        IncRuleQryRspBO incRuleQryRspBO = this.incConfRuleRepository.qryRuleListPage(incRuleListQryBO);
        if (!CollectionUtils.isEmpty((Collection)incRuleQryRspBO.getRows())) {
            Map<Object, Object> ruleAppScopeMap = new HashMap();
            IncRuleQryBO incRuleQryBO = new IncRuleQryBO();
            incRuleQryBO.setConfIds(incRuleQryRspBO.getRows().stream().map(IncRuleList::getConfId).collect(Collectors.toList()));
            List<IncConfRuleApp> incConfRuleApps = this.incConfRuleRepository.qryRuleAppByConfIdList(incRuleQryBO);
            if (!CollectionUtils.isEmpty(incConfRuleApps)) {
                ruleAppScopeMap = incConfRuleApps.stream().collect(Collectors.groupingBy(IncConfRuleApp::getConfId));
            }
            HashMap finalRuleAppScopeMap = ruleAppScopeMap;
            incRuleQryRspBO.getRows().forEach(item -> {
                if (finalRuleAppScopeMap.containsKey(item.getConfId())) {
                    item.setAppOrgName(((List)finalRuleAppScopeMap.get(item.getConfId())).stream().map(IncConfRuleApp::getOrgName).collect(Collectors.joining(";")));
                }
            });
        }
        return incRuleQryRspBO;
    }

    @Override
    public void dealChngStatus(IncRuleChngStatusDO incRuleChngStatusDO) {
        if (incRuleChngStatusDO.getOperType() == 3) {
            this.incConfRuleRepository.deleteRule(incRuleChngStatusDO);
        } else {
            if (incRuleChngStatusDO.getOperType() == 1) {
                incRuleChngStatusDO.setDelTag(IncConstants.DELETE_TAG.NO_DEL);
            } else if (incRuleChngStatusDO.getOperType() == 2) {
                incRuleChngStatusDO.setDelTag(IncConstants.DELETE_TAG.DELETED);
            }
            incRuleChngStatusDO.setUpdateTime(new Date());
            this.incConfRuleRepository.updateRuleStatus(incRuleChngStatusDO);
        }
    }

    @Override
    public void deleteRuleItem(IncRuleItemDO incRuleItemDO) {
        this.incConfRuleRepository.deleteRuleItem(incRuleItemDO);
    }

    @Override
    public List<IncCheckRuleApp> qryRuleConfByOrgId(IncRuleQryBO incRuleQryBO) {
        return this.incConfRuleRepository.qryRuleByOrgId(incRuleQryBO);
    }

    @Override
    public void modifyRule(IncRuleDO incRuleDO) {
        this.incConfRuleRepository.updateIncConfRule(incRuleDO);
        IncRuleChngStatusDO incRuleChngStatusDO = new IncRuleChngStatusDO();
        incRuleChngStatusDO.setConfId(incRuleDO.getConfId());
        this.incConfRuleRepository.deleteRuleByConfId(incRuleChngStatusDO);
        this.addRuleOtherInfo(incRuleDO, incRuleDO.getConfId());
    }

    @Override
    public IncCheckRuleApp qryRuleConfByOrgPath(IncRuleQryBO incRuleQryBO) {
        return this.incConfRuleRepository.qryRuleByOrgPath(incRuleQryBO);
    }

    private void addRuleOtherInfo(IncRuleDO incRuleDO, Long confId) {
        if (!CollectionUtils.isEmpty(incRuleDO.getRuleAppScopes())) {
            ArrayList<IncConfRuleApp> incConfRuleApps = new ArrayList<IncConfRuleApp>();
            incRuleDO.getRuleAppScopes().forEach(rule -> {
                IncConfRuleApp incConfRuleApp = new IncConfRuleApp();
                incConfRuleApp.setId(IdUtil.nextId());
                incConfRuleApp.setConfId(confId);
                incConfRuleApp.setDelTag(IncConstants.DELETE_TAG.NO_DEL);
                incConfRuleApp.setOrgId(rule.getRuleOrgId());
                incConfRuleApp.setOrgName(rule.getRuleOrgName());
                incConfRuleApps.add(incConfRuleApp);
            });
            this.incConfRuleRepository.addConfRuleApp(incConfRuleApps);
        }
        if (!CollectionUtils.isEmpty(incRuleDO.getRuleItemBos())) {
            ArrayList<IncConfRuleItem> incConfRuleItems = new ArrayList<IncConfRuleItem>();
            ArrayList<IncConfRuleGroup> incConfRuleGroups = new ArrayList<IncConfRuleGroup>();
            ArrayList<IncConfRuleDivisor> incConfRuleDivisors = new ArrayList<IncConfRuleDivisor>();
            incRuleDO.getRuleItemBos().forEach(ruleItem -> {
                IncConfRuleItem incConfRuleItem = new IncConfRuleItem();
                incConfRuleItem.setRuleId(IdUtil.nextId());
                incConfRuleItem.setConfId(confId);
                incConfRuleItem.setDelTag(IncConstants.DELETE_TAG.NO_DEL);
                incConfRuleItem.setRuleName(ruleItem.getRuleName());
                incConfRuleItems.add(incConfRuleItem);
                ruleItem.getRuleGroupBos().forEach(group -> {
                    IncConfRuleGroup incConfRuleGroup = IncRu.js(group, IncConfRuleGroup.class);
                    incConfRuleGroup.setGroupId(IdUtil.nextId());
                    incConfRuleGroup.setConfId(confId);
                    incConfRuleGroup.setRuleId(incConfRuleItem.getRuleId());
                    incConfRuleGroups.add(incConfRuleGroup);
                    group.getRuleDivisorBos().forEach(divisor -> {
                        IncConfRuleDivisor incConfRuleDivisor = IncRu.js(divisor, IncConfRuleDivisor.class);
                        incConfRuleDivisor.setId(IdUtil.nextId());
                        incConfRuleDivisor.setConfId(confId);
                        incConfRuleDivisor.setRuleId(incConfRuleItem.getRuleId());
                        incConfRuleDivisor.setGroupId(incConfRuleGroup.getGroupId());
                        incConfRuleDivisors.add(incConfRuleDivisor);
                    });
                });
            });
            this.incConfRuleRepository.addConfRuleItem(incConfRuleItems);
            this.incConfRuleRepository.addConfRuleGroup(incConfRuleGroups);
            this.incConfRuleRepository.addConfRuleDivisor(incConfRuleDivisors);
        }
    }
}

