/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.bargain;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.inc.constants.IncBargainConstants;
import com.tydic.dyc.inc.model.bargain.IncBargainModel;
import com.tydic.dyc.inc.model.bargain.IncBargainQuatationDO;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQryBO;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQuatationQryBO;
import com.tydic.dyc.inc.model.bargain.sub.IncBargain;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainQuatation;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainQuatationItem;
import com.tydic.dyc.inc.model.common.IncCommonModel;
import com.tydic.dyc.inc.model.common.sub.UocOrderTaskInst;
import com.tydic.dyc.inc.service.domainservice.bargain.IncAgainBargainService;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncAgainBargainReqBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncAgainBargainRspBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncBargainItemBO;
import com.tydic.dyc.inc.utils.JsonRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.bargain.IncAgainBargainService"})
public class IncAgainBargainServiceImpl
implements IncAgainBargainService {
    @Autowired
    private IncBargainModel incBargainModel;
    @Autowired
    private IncCommonModel incCommonModel;

    @PostMapping(value={"againBargain"})
    public IncAgainBargainRspBO againBargain(@RequestBody IncAgainBargainReqBO reqBO) {
        this.validateParam(reqBO);
        IncBargain bargain = this.getBargain(reqBO);
        if (bargain == null) {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u8bae\u4ef7\u5355\u4fe1\u606f");
        }
        if (bargain.getVersion().compareTo(bargain.getMaxCount()) >= 0) {
            throw new ZTBusinessException("\u5df2\u8fbe\u5230\u6700\u5927\u8bae\u4ef7\u6b21\u6570\u4e0d\u80fd\u518d\u91cd\u65b0\u53d1\u8d77\u8bae\u4ef7");
        }
        this.updateQuatation(reqBO);
        this.createQuatation(reqBO, bargain);
        this.updateBargain(bargain);
        this.dealTask(reqBO);
        return JsonRuUtil.success(IncAgainBargainRspBO.class);
    }

    private void updateBargain(IncBargain bargain) {
        IncBargain set = new IncBargain();
        set.setVersion(bargain.getVersion() + 1);
        IncBargainQryBO where = new IncBargainQryBO();
        where.setBargainId(bargain.getBargainId());
        this.incBargainModel.updateBargain(set, where);
    }

    private void dealTask(IncAgainBargainReqBO reqBO) {
        UocOrderTaskInst taskInst = new UocOrderTaskInst();
        taskInst.setTaskInstId(reqBO.getTaskId());
        this.incCommonModel.dealTaskInst(taskInst);
    }

    private void updateQuatation(IncAgainBargainReqBO reqBO) {
        IncBargainQuatation set = new IncBargainQuatation();
        set.setStatus(IncBargainConstants.QuatationStatus.QUOTATION_FAILURE);
        IncBargainQuatationQryBO where = new IncBargainQuatationQryBO();
        where.setBargainId(reqBO.getBargainId());
        where.setStatus(IncBargainConstants.QuatationStatus.HAVE_QUOTED_PRICE);
        this.incBargainModel.updateQuatation(set, where);
    }

    private IncBargain getBargain(IncAgainBargainReqBO reqBO) {
        IncBargain incBargain = new IncBargain();
        incBargain.setBargainId(reqBO.getBargainId());
        return this.incBargainModel.getBargainMain(incBargain);
    }

    private void createQuatation(IncAgainBargainReqBO reqBO, IncBargain bargain) {
        IncBargainQuatationDO incBargainQuatationDO = new IncBargainQuatationDO();
        incBargainQuatationDO.setBargainId(reqBO.getBargainId());
        incBargainQuatationDO.setPriceEffectiveTime(reqBO.getQuatationEndTime());
        incBargainQuatationDO.setVersion(bargain.getVersion() + 1);
        ArrayList<IncBargainQuatationItem> itemList = new ArrayList<IncBargainQuatationItem>(reqBO.getItemList().size());
        for (IncBargainItemBO itemBO : reqBO.getItemList()) {
            IncBargainQuatationItem item = new IncBargainQuatationItem();
            item.setBargainItemId(itemBO.getBargainItemId());
            item.setBargainId(reqBO.getBargainId());
            item.setExpectPrice(itemBO.getExpectPrice());
            itemList.add(item);
        }
        incBargainQuatationDO.setItemList(itemList);
        this.incBargainModel.createQuatation(incBargainQuatationDO);
    }

    private void validateParam(IncAgainBargainReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getBargainId() == null) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty((Collection)reqBO.getItemList())) {
            throw new ZTBusinessException("\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getQuatationEndTime() == null) {
            throw new ZTBusinessException("\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

