/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.bargain;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.inc.model.bargain.IncBargainDO;
import com.tydic.dyc.inc.model.bargain.IncBargainItemDO;
import com.tydic.dyc.inc.model.bargain.IncBargainModel;
import com.tydic.dyc.inc.model.bargain.sub.IncBargain;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainStakeholder;
import com.tydic.dyc.inc.service.domainservice.bargain.IncCreateBargainService;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncBargainBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncBargainItemBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncCreateBargainReqBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncCreateBargainRspBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncSupRelaBO;
import com.tydic.dyc.inc.utils.JsonRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.bargain.IncCreateBargainService"})
public class IncCreateBargainServiceImpl
implements IncCreateBargainService {
    @Autowired
    private IncBargainModel incBargainModel;

    @PostMapping(value={"createBargain"})
    public IncCreateBargainRspBO createBargain(@RequestBody IncCreateBargainReqBO reqBO) {
        this.validateParam(reqBO);
        return this.createBargainOrder(reqBO);
    }

    private IncCreateBargainRspBO createBargainOrder(IncCreateBargainReqBO reqBO) {
        Map<Long, IncSupRelaBO> supRelaMap = reqBO.getSupRelaList().stream().collect(Collectors.toMap(IncSupRelaBO::getSupOrgId, o -> o));
        Map<Long, List<IncBargainItemBO>> itemMap = reqBO.getItemList().stream().collect(Collectors.groupingBy(IncBargainItemBO::getSupplierId));
        ArrayList<IncBargain> list = new ArrayList<IncBargain>(itemMap.size());
        for (Map.Entry<Long, List<IncBargainItemBO>> entry : itemMap.entrySet()) {
            IncBargainDO incBargainDO = JsonRuUtil.js(reqBO, IncBargainDO.class);
            incBargainDO.setStakeholder(this.getIncBargainStakeholder(reqBO, supRelaMap.get(entry.getKey())));
            incBargainDO.setItemList(JsonRuUtil.jsl(entry.getValue(), IncBargainItemDO.class));
            IncBargain bargain = this.incBargainModel.createBargain(incBargainDO);
            list.add(bargain);
        }
        IncCreateBargainRspBO rspBO = JsonRuUtil.success(IncCreateBargainRspBO.class);
        rspBO.setList(JsonRuUtil.jsl(list, IncBargainBO.class));
        return rspBO;
    }

    private IncBargainStakeholder getIncBargainStakeholder(IncCreateBargainReqBO reqBO, IncSupRelaBO supRelaBO) {
        IncBargainStakeholder inBargainStakeholder = new IncBargainStakeholder();
        inBargainStakeholder.setProName(reqBO.getProName());
        inBargainStakeholder.setProOrgId(reqBO.getProOrgId());
        inBargainStakeholder.setProRelaMobile(reqBO.getProRelaMobile());
        inBargainStakeholder.setProRelaName(reqBO.getProRelaName());
        inBargainStakeholder.setProName(reqBO.getPurName());
        inBargainStakeholder.setProOrgId(reqBO.getPurOrgId());
        inBargainStakeholder.setProRelaMobile(reqBO.getPurRelaMobile());
        inBargainStakeholder.setProRelaName(reqBO.getProRelaName());
        if (supRelaBO != null) {
            inBargainStakeholder.setSupName(supRelaBO.getSupName());
            inBargainStakeholder.setSupOrgId(supRelaBO.getSupOrgId());
            inBargainStakeholder.setSupRelaName(supRelaBO.getSupRelaName());
            inBargainStakeholder.setSupRelaMobile(supRelaBO.getSupRelaMobile());
        }
        return inBargainStakeholder;
    }

    private void validateParam(IncCreateBargainReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getCreateOperId() == null) {
            throw new ZTBusinessException("\u521b\u5efa\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getCreateOperName())) {
            throw new ZTBusinessException("\u521b\u5efa\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getPurName())) {
            throw new ZTBusinessException("\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPurOrgId() == null) {
            throw new ZTBusinessException("\u91c7\u8d2d\u5355\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getQuatationEndTime() == null) {
            throw new ZTBusinessException("\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getPurRelaName())) {
            throw new ZTBusinessException("\u91c7\u8d2d\u5355\u4f4d\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getPurRelaMobile())) {
            throw new ZTBusinessException("\u91c7\u8d2d\u5355\u4f4d\u8054\u7cfb\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty((Collection)reqBO.getSupRelaList())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getItemList())) {
            throw new ZTBusinessException("\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

