/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.bargain;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.inc.model.bargain.IncBargainModel;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainItemQryBO;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQuatationQryBO;
import com.tydic.dyc.inc.model.bargain.sub.IncBargain;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainItem;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainQuatation;
import com.tydic.dyc.inc.service.domainservice.bargain.IncOrderBargainItemService;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncBargainItemBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncOrderBargainItemReqBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncOrderBargainItemRspBO;
import com.tydic.dyc.inc.utils.JsonRuUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.bargain.IncOrderBargainItemService"})
public class IncOrderBargainItemServiceImpl
implements IncOrderBargainItemService {
    @Autowired
    private IncBargainModel incBargainModel;

    @PostMapping(value={"orderBargainItem"})
    public IncOrderBargainItemRspBO orderBargainItem(@RequestBody IncOrderBargainItemReqBO reqBO) {
        this.validateParam(reqBO);
        IncBargain bargain = this.getBargain(reqBO);
        if (bargain == null) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u8bae\u4ef7\u5355");
        }
        if ("YJ_YJ_YJWC".equals(bargain.getBargainStatus())) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355\u72b6\u6001\u4e0d\u662f\u8bae\u4ef7\u5b8c\u6210\u4e0d\u80fd\u4e0b\u5355");
        }
        this.checkPriceEffectiveTime(bargain);
        List<IncBargainItem> list = this.getBargainItemList(reqBO);
        IncOrderBargainItemRspBO rspBO = JsonRuUtil.success(IncOrderBargainItemRspBO.class);
        rspBO.setList(JsonRuUtil.jsl(list, IncBargainItemBO.class));
        return rspBO;
    }

    private void checkPriceEffectiveTime(IncBargain bargain) {
        IncBargainQuatationQryBO qryBO = new IncBargainQuatationQryBO();
        qryBO.setBargainId(bargain.getBargainId());
        qryBO.setVersion(bargain.getVersion());
        IncBargainQuatation quatation = this.incBargainModel.getQuatation(qryBO);
        Date now = new Date();
        if (now.compareTo(quatation.getPriceEffectiveTime()) < 0) {
            throw new ZTBusinessException("\u5df2\u8d85\u8fc7\u4ef7\u683c\u6709\u6548\u65f6\u95f4\u7981\u6b62\u4e0b\u5355");
        }
    }

    private List<IncBargainItem> getBargainItemList(IncOrderBargainItemReqBO reqBO) {
        IncBargainItemQryBO incBargainItemQryBO = new IncBargainItemQryBO();
        incBargainItemQryBO.setBargainId(reqBO.getBargainId());
        List<IncBargainItem> bargainItemList = this.incBargainModel.getBargainItemList(incBargainItemQryBO);
        if (CollectionUtils.isEmpty(bargainItemList)) {
            throw new ZTBusinessException("\u672a\u627e\u5230\u8bae\u4ef7\u5355\u660e\u7ec6\u4fe1\u606f");
        }
        for (IncBargainItem item : bargainItemList) {
            if (item.getTransactionPrice() != null && BigDecimal.ZERO.compareTo(item.getTransactionPrice()) < 0) continue;
            throw new ZTBusinessException("\u8bae\u4ef7\u5355\u660e\u7ec6\u6210\u4ea4\u4ef7\u683c\u5f02\u5e38");
        }
        return bargainItemList;
    }

    private IncBargain getBargain(IncOrderBargainItemReqBO reqBO) {
        IncBargain incBargain = new IncBargain();
        incBargain.setBargainId(reqBO.getBargainId());
        return this.incBargainModel.getBargainMain(incBargain);
    }

    private void validateParam(IncOrderBargainItemReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getBargainId() == null) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

