/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.bargain;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.inc.constants.IncBargainConstants;
import com.tydic.dyc.inc.model.bargain.IncBargainModel;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQryBO;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQuatationQryBO;
import com.tydic.dyc.inc.model.bargain.sub.IncBargain;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainQuatation;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainSale;
import com.tydic.dyc.inc.service.domainservice.bargain.IncEsSyncService;
import com.tydic.dyc.inc.service.domainservice.bargain.IncOrderCallbackBargainService;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncBargainSaleBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncEsSyncReqBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncOrderCallbackBargainReqBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncOrderCallbackBargainRspBO;
import com.tydic.dyc.inc.utils.IdUtil;
import com.tydic.dyc.inc.utils.JsonRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.bargain.IncOrderCallbackBargainService"})
public class IncOrderCallbackBargainServiceImpl
implements IncOrderCallbackBargainService {
    @Autowired
    private IncBargainModel incBargainModel;
    @Autowired
    private IncEsSyncService incEsSyncService;

    @PostMapping(value={"orderCallbackBargain"})
    public IncOrderCallbackBargainRspBO orderCallbackBargain(@RequestBody IncOrderCallbackBargainReqBO reqBO) {
        this.validateParam(reqBO);
        this.insertBargainSaleBatch(reqBO);
        this.dealBargain(reqBO);
        IncEsSyncReqBO incEsSyncReqBO = new IncEsSyncReqBO();
        incEsSyncReqBO.setBargainId(reqBO.getBargainId());
        this.incEsSyncService.sync(incEsSyncReqBO);
        return JsonRuUtil.success(IncOrderCallbackBargainRspBO.class);
    }

    private void dealBargain(IncOrderCallbackBargainReqBO reqBO) {
        IncBargainQuatation set = new IncBargainQuatation();
        set.setOrderTiem(reqBO.getOrderTime());
        set.setStatus(IncBargainConstants.QuatationStatus.ORDER);
        IncBargainQuatationQryBO where = new IncBargainQuatationQryBO();
        where.setStatus(IncBargainConstants.QuatationStatus.QUOTATION_OVER);
        where.setBargainId(reqBO.getBargainId());
        this.incBargainModel.updateQuatation(set, where);
        IncBargain incBargainSet = new IncBargain();
        incBargainSet.setOrderTime(reqBO.getOrderTime());
        incBargainSet.setBargainStatus("YJ_YJ_YXD");
        IncBargainQryBO incBargainWhere = new IncBargainQryBO();
        incBargainWhere.setBargainId(reqBO.getBargainId());
        this.incBargainModel.updateBargain(incBargainSet, incBargainWhere);
    }

    private void insertBargainSaleBatch(IncOrderCallbackBargainReqBO reqBO) {
        ArrayList<IncBargainSale> incBargainSales = new ArrayList<IncBargainSale>();
        for (IncBargainSaleBO saleBO : reqBO.getSaleList()) {
            IncBargainSale incBargainSale = new IncBargainSale();
            incBargainSale.setBargainId(reqBO.getBargainId());
            incBargainSale.setCreateOperId(reqBO.getCreateOperId());
            incBargainSale.setCreateOperName(reqBO.getCreateOperName());
            incBargainSale.setCreateTime(reqBO.getOrderTime());
            incBargainSale.setId(IdUtil.nextId());
            incBargainSale.setOrderId(saleBO.getOrderId());
            incBargainSale.setSaleOrderId(saleBO.getSaleOrderId());
            incBargainSale.setSaleOrderNo(saleBO.getSaleOrderNo());
            incBargainSales.add(incBargainSale);
        }
        this.incBargainModel.insertBargainSaleBatch(incBargainSales);
    }

    private void validateParam(IncOrderCallbackBargainReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderTime() == null) {
            throw new ZTBusinessException("\u4e0b\u5355\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getBargainId() == null) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSaleList())) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

