/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.bargain;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.inc.model.bargain.IncBargainModel;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQuatationQryBO;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainQuatation;
import com.tydic.dyc.inc.service.domainservice.bargain.IncQryQuatationListService;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncBargainQuatationBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncQryQuatationListReqBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncQryQuatationListRspBO;
import com.tydic.dyc.inc.utils.JsonRuUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.bargain.IncQryQuatationListService"})
public class IncQryQuatationListServiceImpl
implements IncQryQuatationListService {
    @Autowired
    private IncBargainModel incBargainModel;

    @PostMapping(value={"qryQuatationList"})
    public IncQryQuatationListRspBO qryQuatationList(@RequestBody IncQryQuatationListReqBO reqBO) {
        this.validateParam(reqBO);
        IncBargainQuatationQryBO qryBO = new IncBargainQuatationQryBO();
        qryBO.setBargainId(reqBO.getBargainId());
        qryBO.setOrderBy("version desc");
        List<IncBargainQuatation> quatationList = this.incBargainModel.getQuatationList(qryBO);
        IncQryQuatationListRspBO rspBO = JsonRuUtil.success(IncQryQuatationListRspBO.class);
        rspBO.setList(JsonRuUtil.jsl(quatationList, IncBargainQuatationBO.class));
        return rspBO;
    }

    private void validateParam(IncQryQuatationListReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getBargainId() == null) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

