/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.bargain;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.inc.constants.IncBargainConstants;
import com.tydic.dyc.inc.model.bargain.IncBargainModel;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQryBO;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQuatationItemQryBO;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQuatationQryBO;
import com.tydic.dyc.inc.model.bargain.sub.IncBargain;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainQuatation;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainQuatationItem;
import com.tydic.dyc.inc.model.common.IncCommonModel;
import com.tydic.dyc.inc.model.common.sub.UocOrderTaskInst;
import com.tydic.dyc.inc.service.domainservice.bargain.IncQuotationBargainService;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncBargainQuatationItemBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncQuotationBargainReqBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncQuotationBargainRspBO;
import com.tydic.dyc.inc.utils.JsonRuUtil;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.bargain.IncQuotationBargainService"})
public class IncQuotationBargainServiceImpl
implements IncQuotationBargainService {
    @Autowired
    private IncBargainModel incBargainModel;
    @Autowired
    private IncCommonModel incCommonModel;

    @PostMapping(value={"quotationBargain"})
    public IncQuotationBargainRspBO quotationBargain(@RequestBody IncQuotationBargainReqBO reqBO) {
        this.validateParam(reqBO);
        IncBargain bargain = this.getBargain(reqBO);
        if (bargain == null) {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u8bae\u4ef7\u5355\u4fe1\u606f");
        }
        if ("YJ_YJ_BJZ".equals(bargain.getBargainStatus())) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355\u72b6\u6001\u4e0d\u662f\u62a5\u4ef7\u4e2d\u4e0d\u80fd\u8fdb\u884c\u62a5\u4ef7");
        }
        this.updateQuatationItem(reqBO);
        Date time = new Date();
        this.updateQuatation(bargain, reqBO, time);
        this.updateBargain(reqBO, time);
        this.dealTask(reqBO);
        return JsonRuUtil.success(IncQuotationBargainRspBO.class);
    }

    private void dealTask(IncQuotationBargainReqBO reqBO) {
        UocOrderTaskInst taskInst = new UocOrderTaskInst();
        taskInst.setTaskInstId(reqBO.getTaskId());
        this.incCommonModel.dealTaskInst(taskInst);
    }

    private void updateBargain(IncQuotationBargainReqBO reqBO, Date time) {
        IncBargain set = new IncBargain();
        set.setBargainStatus("YJ_YJ_YBJ");
        set.setOrderTime(time);
        IncBargainQryBO where = new IncBargainQryBO();
        where.setBargainId(reqBO.getBargainId());
        this.incBargainModel.updateBargain(set, where);
    }

    private IncBargain getBargain(IncQuotationBargainReqBO reqBO) {
        IncBargain incBargain = new IncBargain();
        incBargain.setBargainId(reqBO.getBargainId());
        return this.incBargainModel.getBargainMain(incBargain);
    }

    private void updateQuatation(IncBargain bargain, IncQuotationBargainReqBO reqBO, Date time) {
        IncBargainQuatation set = new IncBargainQuatation();
        set.setStatus(IncBargainConstants.QuatationStatus.HAVE_QUOTED_PRICE);
        set.setQuatationOperId(reqBO.getQuatationOperId());
        set.setQuatationOperName(reqBO.getQuatationOperName());
        set.setQuatationTime(time);
        set.setQuatationRemark(reqBO.getQuatationRemark());
        set.setPriceEffectiveTime(reqBO.getPriceEffectiveTime());
        IncBargainQuatationQryBO where = new IncBargainQuatationQryBO();
        where.setBargainId(bargain.getBargainId());
        where.setVersion(bargain.getVersion());
        this.incBargainModel.updateQuatation(set, where);
    }

    private void updateQuatationItem(IncQuotationBargainReqBO reqBO) {
        for (IncBargainQuatationItemBO itemBO : reqBO.getItemList()) {
            IncBargainQuatationItem set = new IncBargainQuatationItem();
            set.setExclusivePrice(itemBO.getExclusivePrice());
            IncBargainQuatationItemQryBO where = new IncBargainQuatationItemQryBO();
            where.setBargainId(reqBO.getBargainId());
            where.setQuatationItemId(itemBO.getQuatationItemId());
            where.setBargainItemId(itemBO.getBargainItemId());
            this.incBargainModel.updateQuatationItem(set, where);
        }
    }

    private void validateParam(IncQuotationBargainReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getQuatationOperId() == null) {
            throw new ZTBusinessException("\u62a5\u4ef7\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getQuatationOperName())) {
            throw new ZTBusinessException("\u62a5\u4ef7\u4eba\u540d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getItemList())) {
            throw new ZTBusinessException("\u62a5\u4ef7\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPriceEffectiveTime() == null) {
            throw new ZTBusinessException("\u4ef7\u683c\u6709\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

