/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.inquiryorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrder;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrderAccessory;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncPerformanceInfo;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncResultScope;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncSupplier;
import com.tydic.dyc.inc.model.inquiryorder.sub.InsSkuItem;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.IncAddIncOrderService;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncAddIncOrderReqBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncAddIncOrderRspBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderAccessoryBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncResultScopeBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncSkuItemBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncSupplierBO;
import com.tydic.dyc.inc.utils.IdUtil;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.inquiryorder.IncAddIncOrderService"})
public class IncAddIncOrderServiceImpl
implements IncAddIncOrderService {
    @Autowired
    private IncOrderModel incOrderModel;

    @PostMapping(value={"addIncOrder"})
    public IncAddIncOrderRspBO addIncOrder(@RequestBody IncAddIncOrderReqBO reqBO) {
        IncAddIncOrderRspBO rsp = IncRu.success(IncAddIncOrderRspBO.class);
        Long incOrderId = IdUtil.nextId();
        this.insertIncOrder(reqBO, incOrderId);
        this.insertSkuItems(reqBO, incOrderId);
        if (IncConstants.PurchaseModel.INVITE.equals(reqBO.getPurchaseModel())) {
            this.insertSupplier(reqBO, incOrderId);
        }
        if (ObjectUtil.isNotNull((Object)reqBO.getIncPerformanceInfoBO())) {
            this.insertPerformanceInfo(reqBO, incOrderId);
        }
        this.insertResultScopes(reqBO, incOrderId);
        if (ObjectUtil.isNotEmpty((Object)reqBO.getIncOrderAccessoryBOList())) {
            this.insertAccessorys(reqBO, incOrderId);
        }
        rsp.setIncOrderId(incOrderId);
        return rsp;
    }

    private void insertAccessorys(IncAddIncOrderReqBO reqBO, Long incOrderId) {
        ArrayList<IncOrderAccessory> incOrderAccessories = new ArrayList<IncOrderAccessory>();
        for (IncOrderAccessoryBO bo : reqBO.getIncOrderAccessoryBOList()) {
            IncOrderAccessory incOrderAccessory = new IncOrderAccessory();
            BeanUtils.copyProperties((Object)bo, (Object)incOrderAccessory);
            incOrderAccessory.setId(IdUtil.nextId());
            incOrderAccessory.setObjId(incOrderId);
            incOrderAccessory.setObjType(IncConstants.AccessoryObjType.INC);
            incOrderAccessory.setOrderId(incOrderId);
            incOrderAccessory.setAttachmentType(IncConstants.AccessoryAttachmentType.INC);
            incOrderAccessory.setCreateOperId(reqBO.getUserId().toString());
            incOrderAccessory.setCreateTime(new Date());
            incOrderAccessories.add(incOrderAccessory);
        }
        this.incOrderModel.addOrderAccessoryBatch(incOrderAccessories);
    }

    private void insertResultScopes(IncAddIncOrderReqBO reqBO, Long incOrderId) {
        ArrayList<IncResultScope> incResultScopes = new ArrayList<IncResultScope>();
        for (IncResultScopeBO bo : reqBO.getIncResultScopeBOList()) {
            IncResultScope incResultScope = new IncResultScope();
            BeanUtils.copyProperties((Object)bo, (Object)incResultScope);
            incResultScope.setIncResultScopeId(IdUtil.nextId());
            incResultScope.setOrderId(incOrderId);
            incResultScope.setScopeType(IncConstants.TemplateScopeType.INC);
            incResultScope.setCreateOperId(reqBO.getUserId().toString());
            incResultScope.setCreateOperName(reqBO.getName());
            incResultScope.setCreateTime(new Date());
            incResultScopes.add(incResultScope);
        }
        this.incOrderModel.addIncResultScopeBatch(incResultScopes);
    }

    private void insertPerformanceInfo(IncAddIncOrderReqBO reqBO, Long incOrderId) {
        IncPerformanceInfo incPerformanceInfo = new IncPerformanceInfo();
        BeanUtils.copyProperties((Object)reqBO.getIncPerformanceInfoBO(), (Object)incPerformanceInfo);
        incPerformanceInfo.setIncPerformanceInfoId(IdUtil.nextId());
        incPerformanceInfo.setIncOrderId(incOrderId);
        incPerformanceInfo.setCreateOperId(reqBO.getUserId().toString());
        incPerformanceInfo.setCreateOperName(reqBO.getName());
        incPerformanceInfo.setCreateTime(new Date());
        this.incOrderModel.addIncPerformanceInfo(incPerformanceInfo);
    }

    private void insertSupplier(IncAddIncOrderReqBO reqBO, Long incOrderId) {
        ArrayList<IncSupplier> incSuppliers = new ArrayList<IncSupplier>();
        for (IncSupplierBO bo : reqBO.getIncSupplierBOList()) {
            IncSupplier incSupplier = new IncSupplier();
            BeanUtils.copyProperties((Object)bo, (Object)incSupplier);
            incSupplier.setIncSupplierId(IdUtil.nextId());
            incSupplier.setIncOrderId(incOrderId);
            incSupplier.setCreateOperId(reqBO.getUserId().toString());
            incSupplier.setCreateOperName(reqBO.getName());
            incSupplier.setCreateTime(new Date());
            incSuppliers.add(incSupplier);
        }
        this.incOrderModel.addIncSupplierBatch(incSuppliers);
    }

    private void insertSkuItems(IncAddIncOrderReqBO reqBO, Long incOrderId) {
        ArrayList<InsSkuItem> insSkuItems = new ArrayList<InsSkuItem>();
        for (IncSkuItemBO bo : reqBO.getIncSkuItemBOList()) {
            InsSkuItem insSkuItem = new InsSkuItem();
            BeanUtils.copyProperties((Object)bo, (Object)insSkuItem);
            insSkuItem.setInsSkuItemId(IdUtil.nextId());
            insSkuItem.setIncOrderId(incOrderId);
            insSkuItem.setCreateOperId(reqBO.getUserId().toString());
            insSkuItem.setCreateOperName(reqBO.getName());
            insSkuItem.setCreateTime(new Date());
            insSkuItems.add(insSkuItem);
        }
        this.incOrderModel.addIncSkuItemBatch(insSkuItems);
    }

    private void insertIncOrder(IncAddIncOrderReqBO reqBO, Long incOrderId) {
        IncOrder incOrder = new IncOrder();
        BeanUtils.copyProperties((Object)reqBO, (Object)incOrder);
        incOrder.setIncOrderId(incOrderId);
        if (IncConstants.IncType.INQUIRY.equals(reqBO.getIncType())) {
            incOrder.setIncOrderState("INC_DRAFT");
        } else {
            incOrder.setIncOrderState("INC_DRAFT");
        }
        incOrder.setIncOrderCode(this.incOrderModel.getOrderNoSingle(reqBO.getIncType()));
        incOrder.setVersionNo("V01");
        incOrder.setCreateOperId(reqBO.getUserId().toString());
        incOrder.setCreateOperName(reqBO.getName());
        incOrder.setCreateTime(new Date());
        incOrder.setCreateOrgId(reqBO.getOrgId().toString());
        incOrder.setCreateOrgName(reqBO.getOrgName());
        incOrder.setCreateOrgPath(reqBO.getOrgPath());
        this.incOrderModel.addIncOrder(incOrder);
    }
}

