/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.inquiryorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.inc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.inc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.inc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.inc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.IncApproveCreateService;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncApproveCreateServiceReqBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncApproveCreateServiceRspBO;
import com.tydic.dyc.inc.utils.IdUtil;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.inquiryorder.IncApproveCreateService"})
public class IncApproveCreateServiceImpl
implements IncApproveCreateService {
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @PostMapping(value={"createApprove"})
    public IncApproveCreateServiceRspBO createApprove(@RequestBody IncApproveCreateServiceReqBO reqBO) {
        this.validateArg(reqBO);
        IncApproveCreateServiceRspBO rspBo = IncRu.success(IncApproveCreateServiceRspBO.class);
        long auditId = IdUtil.nextId();
        UocAuditOrderDo auditDo = IncRu.js(reqBO, UocAuditOrderDo.class);
        auditDo.setAuditOrderId(auditId);
        auditDo.setCreateOperId(reqBO.getUserId().toString());
        auditDo.setCreateOperName(reqBO.getName());
        auditDo.setOrderId(reqBO.getOrderId());
        auditDo.setAuditOrderStatus("2");
        ArrayList<UocApprovalObj> objList = new ArrayList<UocApprovalObj>();
        auditDo.setApprovalObjs(objList);
        UocApprovalObj approvalObj = new UocApprovalObj();
        objList.add(approvalObj);
        approvalObj.setObjId(reqBO.getObjId().toString());
        approvalObj.setId(IdUtil.nextId());
        approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
        approvalObj.setOrderId(reqBO.getOrderId());
        approvalObj.setObjType(reqBO.getObjType());
        approvalObj.setObjBusiType(reqBO.getObjBusiType());
        UocApprovalLog uocApprovalLog = new UocApprovalLog();
        uocApprovalLog.setAuditOrderId(auditId);
        uocApprovalLog.setId(IdUtil.nextId());
        uocApprovalLog.setOperid(reqBO.getUserId().toString());
        uocApprovalLog.setOperName(reqBO.getName());
        uocApprovalLog.setOperDept(reqBO.getOrgId() + "");
        uocApprovalLog.setCreateTime(new Date());
        uocApprovalLog.setObjNum(objList.size());
        uocApprovalLog.setObjType(reqBO.getObjBusiType());
        uocApprovalLog.setAuditResult(IncConstants.AUDIT_TYPE.CREATE);
        auditDo.setApprovalLog(uocApprovalLog);
        this.iUocAuditOrderModel.saveAudit(auditDo);
        rspBo.setAuditOrderId(Long.valueOf(auditId));
        return rspBo;
    }

    private void validateArg(IncApproveCreateServiceReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocApproveCreateServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getObjId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61id\uff0c\u4f8b\u5982\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getObjType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getObjBusiType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61\u4e1a\u52a1\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

