/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.inquiryorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncCommunicateInfo;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.IncBatchAddIncCommunicateInfoService;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncBatchAddIncCommunicateInfoReqBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncBatchAddIncCommunicateInfoRspBO;
import com.tydic.dyc.inc.utils.IdUtil;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.inquiryorder.IncBatchAddIncCommunicateInfoService"})
public class IncBatchAddIncCommunicateInfoServiceImpl
implements IncBatchAddIncCommunicateInfoService {
    @Autowired
    private IncOrderModel incOrderModel;

    @PostMapping(value={"batchAddIncCommunicateInfo"})
    public IncBatchAddIncCommunicateInfoRspBO batchAddIncCommunicateInfo(@RequestBody IncBatchAddIncCommunicateInfoReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("8888", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getList())) {
            throw new BaseBusinessException("8888", "\u5165\u53c2\u65b0\u589e\u96c6\u5408\u4e3a\u7a7a");
        }
        List<IncCommunicateInfo> addList = reqBO.getList().stream().map(item -> {
            IncCommunicateInfo addBO = IncRu.js(item, IncCommunicateInfo.class);
            addBO.setIncCommunicateInfoId(IdUtil.nextId());
            addBO.setCommunicateType(reqBO.getCommunicateType());
            addBO.setRelaOrderId(reqBO.getRelaOrderId());
            addBO.setCreateOperId(reqBO.getUserId() + "");
            addBO.setCreateOperName(reqBO.getName());
            addBO.setCreateTime(new Date());
            addBO.setDelTag(IncConstants.DelTag.NO);
            return addBO;
        }).collect(Collectors.toList());
        this.incOrderModel.batchAddIncCommunicateInfo(addList);
        return IncRu.success("\u6210\u529f", IncBatchAddIncCommunicateInfoRspBO.class);
    }
}

