/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.inquiryorder;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrder;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrderQryTaskSubBO;
import com.tydic.dyc.inc.model.quotation.IncQuatationModel;
import com.tydic.dyc.inc.model.quotation.sub.IncQuatationSkuItem;
import com.tydic.dyc.inc.model.taskcommon.IncTaskCommonModel;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.IncOrderQryTaskService;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderQryTaskBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderQryTaskReqBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderQryTaskRspBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncSyncEsBO;
import com.tydic.dyc.inc.utils.IncElasticsearchUtil;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.inquiryorder.IncOrderQryTaskService"})
public class IncOrderQryTaskServiceImpl
implements IncOrderQryTaskService {
    @Autowired
    private IncOrderModel incOrderModel;
    @Autowired
    private IncQuatationModel incQuatationModel;
    @Autowired
    private IncTaskCommonModel incTaskCommonModel;
    @Autowired
    private IncElasticsearchUtil incElasticsearchUtil;
    @Value(value="${INC_ORDER_INDEX_NAME:inc_order}")
    private String INC_ORDER_INDEX_NAME;

    @PostMapping(value={"dealBiddingOrderTask"})
    public IncOrderQryTaskRspBO dealBiddingOrderTask(@RequestBody IncOrderQryTaskReqBO reqBO) {
        ArrayList updateIncOrderIdList = new ArrayList();
        IncOrderQryTaskRspBO rspBO = new IncOrderQryTaskRspBO();
        ArrayList<IncOrderQryTaskBO> incOrderListStart = new ArrayList<IncOrderQryTaskBO>();
        ArrayList<IncOrderQryTaskBO> incOrderListEnd = new ArrayList<IncOrderQryTaskBO>();
        this.dealStart(reqBO, incOrderListStart);
        List<Long> invalidIds = this.dealEnd(reqBO, incOrderListEnd);
        if (!CollectionUtils.isEmpty(invalidIds)) {
            incOrderListEnd.removeIf(item -> invalidIds.contains(item.getIncOrderId()));
        }
        List<IncSyncEsBO> incSyncEsBOS = this.dealUpdateStateInValid(invalidIds);
        rspBO.setUpdateIncOrderIdList(incSyncEsBOS);
        incOrderListStart.addAll(incOrderListEnd);
        rspBO.setIncOrderList(incOrderListStart);
        return rspBO;
    }

    private List<IncSyncEsBO> dealUpdateStateInValid(List<Long> invalidIds) {
        if (!CollectionUtils.isEmpty(invalidIds)) {
            IncOrder order = new IncOrder();
            order.setIncOrderIds(invalidIds);
            order.setIncOrderState("INC_FAIL_SOLD");
            this.incOrderModel.updateIncOrderBatchIds(order);
            return invalidIds.stream().map(e -> {
                IncSyncEsBO incSyncEsBO = new IncSyncEsBO();
                incSyncEsBO.setUpdateIncOrderId(e);
                return incSyncEsBO;
            }).collect(Collectors.toList());
        }
        return null;
    }

    @PostMapping(value={"dealInquiryOrderTask"})
    public IncOrderQryTaskRspBO dealInquiryOrderTask(@RequestBody IncOrderQryTaskReqBO reqBO) {
        IncOrderQryTaskRspBO rspBO = IncRu.success(IncOrderQryTaskRspBO.class);
        ArrayList<IncOrderQryTaskBO> resultList = new ArrayList<IncOrderQryTaskBO>();
        ArrayList<IncOrderQryTaskBO> quatationBoList = new ArrayList<IncOrderQryTaskBO>();
        this.qryQuotations(reqBO, resultList, quatationBoList);
        this.qryIncOrders(reqBO, quatationBoList, resultList);
        this.dealUpdateState(resultList);
        rspBO.setIncOrderList(resultList);
        return rspBO;
    }

    private void qryIncOrders(IncOrderQryTaskReqBO reqBO, List<IncOrderQryTaskBO> quatationBoList, ArrayList<IncOrderQryTaskBO> resultList) {
        if (!CollectionUtils.isEmpty(quatationBoList)) {
            List<Long> list = quatationBoList.stream().map(IncOrderQryTaskBO::getIncOrderId).collect(Collectors.toList());
            IncOrderQryTaskSubBO incOrderQryTaskSubBO = this.incOrderModel.qryOrderListRangeTime(2, list, 1);
            if ("0000".equals(incOrderQryTaskSubBO.getRespCode()) && !CollectionUtils.isEmpty(incOrderQryTaskSubBO.getIncOrderList())) {
                resultList.addAll(incOrderQryTaskSubBO.getIncOrderList());
            }
        }
    }

    private void qryQuotations(IncOrderQryTaskReqBO reqBO, ArrayList<IncOrderQryTaskBO> resultList, List<IncOrderQryTaskBO> quatationBoList) {
        List<IncOrderQryTaskBO> taskBOList = this.incQuatationModel.qryBidInfoListEndTime();
        if (!CollectionUtils.isEmpty(taskBOList)) {
            quatationBoList = this.filterQuotationList(taskBOList);
            resultList.addAll(quatationBoList);
        }
    }

    private void dealUpdateState(ArrayList<IncOrderQryTaskBO> resultList) {
        if (!CollectionUtils.isEmpty(resultList)) {
            IncOrder incOrder = new IncOrder();
            List<Long> incOrderIds = resultList.stream().map(IncOrderQryTaskBO::getIncOrderId).collect(Collectors.toList());
            incOrder.setIncOrderIds(incOrderIds);
            incOrder.setIncOrderState("INC_COMPLETE");
            this.incOrderModel.updateIncOrderBatchIds(incOrder);
        }
    }

    private List<IncOrderQryTaskBO> filterQuotationList(List<IncOrderQryTaskBO> taskBOList) {
        ArrayList<IncOrderQryTaskBO> resultTasks = new ArrayList<IncOrderQryTaskBO>();
        Map<Long, List<IncOrderQryTaskBO>> map = taskBOList.stream().collect(Collectors.groupingBy(IncOrderQryTaskBO::getIncOrderId));
        for (Long incOrderId : map.keySet()) {
            List<IncOrderQryTaskBO> taskBOList1 = map.get(incOrderId);
            taskBOList1.sort(Comparator.comparing(IncOrderQryTaskBO::getTime).reversed());
            resultTasks.add(taskBOList1.get(0));
        }
        return resultTasks;
    }

    private List<Long> dealEnd(IncOrderQryTaskReqBO reqBO, List<IncOrderQryTaskBO> incOrderList) {
        IncOrderQryTaskSubBO incOrderQryTaskSubBO = this.incOrderModel.qryOrderListRangeTime(2, null, 2);
        if ("0000".equals(incOrderQryTaskSubBO.getRespCode())) {
            if (!CollectionUtils.isEmpty(incOrderQryTaskSubBO.getIncOrderList())) {
                List orderQryTaskBOS = JUtil.jsl(incOrderQryTaskSubBO.getIncOrderList(), IncOrderQryTaskBO.class);
                incOrderList.addAll(orderQryTaskBOS);
                List<Long> list = orderQryTaskBOS.stream().map(IncOrderQryTaskBO::getIncOrderId).collect(Collectors.toList());
                List<IncQuatationSkuItem> incQuatationSkuItems = this.incQuatationModel.qryQuotationListByIds(list);
                if (!CollectionUtils.isEmpty(incQuatationSkuItems)) {
                    List validIds = incQuatationSkuItems.stream().map(IncQuatationSkuItem::getIncOrderId).distinct().collect(Collectors.toList());
                    List<Long> inValidIds = incOrderList.stream().filter(e -> !validIds.contains(e.getIncOrderId())).map(IncOrderQryTaskBO::getIncOrderId).collect(Collectors.toList());
                    return inValidIds;
                }
                return incOrderList.stream().map(IncOrderQryTaskBO::getIncOrderId).collect(Collectors.toList());
            }
            return new ArrayList<Long>();
        }
        throw new ZTBusinessException(incOrderQryTaskSubBO.getRespDesc());
    }

    private void dealStart(IncOrderQryTaskReqBO reqBO, List<IncOrderQryTaskBO> incOrderList) {
        IncOrderQryTaskSubBO incOrderQryTaskSubBO = this.incOrderModel.qryOrderListRangeTime(1, null, null);
        if ("0000".equals(incOrderQryTaskSubBO.getRespCode())) {
            if (!CollectionUtils.isEmpty(incOrderQryTaskSubBO.getIncOrderList())) {
                List orderQryTaskBOS = JUtil.jsl(incOrderQryTaskSubBO.getIncOrderList(), IncOrderQryTaskBO.class);
                incOrderList.addAll(orderQryTaskBOS);
            }
        } else {
            throw new ZTBusinessException(incOrderQryTaskSubBO.getRespDesc());
        }
    }

    private void syncEs(List<Long> incOrderIds, String incQuatationState) {
        ConcurrentHashMap<Long, Map<String, Object>> maps = new ConcurrentHashMap<Long, Map<String, Object>>();
        for (Long id : incOrderIds) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("incOrderState", incQuatationState);
            maps.put(id, map);
        }
        this.incElasticsearchUtil.updateBatchData(this.INC_ORDER_INDEX_NAME, maps);
    }
}

