/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.inquiryorder;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderDO;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.inquiryorder.qrybo.IncOrderQryBO;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrder;
import com.tydic.dyc.inc.model.taskcommon.IncTaskCommonModel;
import com.tydic.dyc.inc.model.taskcommon.qrybo.IncApprovalObjQryBo;
import com.tydic.dyc.inc.model.taskcommon.sub.IncOrderProcInst;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.IncOrderTerminateService;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderTerminateReqBo;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderTerminateRspBo;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncTaskInfoBO;
import com.tydic.dyc.inc.utils.IncElasticsearchUtil;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.inquiryorder.IncOrderTerminateService"})
public class IncOrderTerminateServiceImpl
implements IncOrderTerminateService {
    private static final Logger log = LoggerFactory.getLogger(IncOrderTerminateServiceImpl.class);
    @Autowired
    private IncOrderModel incOrderModel;
    @Autowired
    private IncTaskCommonModel incTaskCommonModel;
    @Autowired
    private IncElasticsearchUtil incElasticsearchUtil;
    @Value(value="${INC_ORDER_INDEX_NAME:inc_order}")
    private String INC_ORDER_INDEX_NAME;
    @Value(value="${INC_ORDER_APPROVAL_INDEX_NAME:inc_order_audit}")
    private String INC_ORDER_APPROVAL_INDEX_NAME;
    @Value(value="${es.type:_doc}")
    private String esType;

    @PostMapping(value={"terminate"})
    public IncOrderTerminateRspBo terminate(@RequestBody IncOrderTerminateReqBo reqBo) {
        this.validateState(reqBo);
        IncOrderTerminateRspBo success = IncRu.success(IncOrderTerminateRspBo.class);
        this.dealUpdateState(reqBo);
        IncApprovalObjQryBo qryBo = new IncApprovalObjQryBo();
        qryBo.setOrderId(reqBo.getIncOrderId());
        IncTaskInfoBO taskInfoBO = this.incTaskCommonModel.qryProcTaskInfo(qryBo);
        if (ObjectUtils.isEmpty((Object)taskInfoBO)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5355\u636e\u6fc0\u6d3b\u7684\u6d41\u7a0b\u4fe1\u606f");
        }
        success.setProcInstId(taskInfoBO.getProcInstId());
        success.setTaskInstId(taskInfoBO.getTaskId());
        this.dealEndProcess(reqBo);
        return success;
    }

    private void dealEndProcess(IncOrderTerminateReqBo reqBo) {
        IncOrderProcInst incOrderProcInst = new IncOrderProcInst();
        incOrderProcInst.setOrderId(reqBo.getIncOrderId());
        incOrderProcInst.setFinishTag(IncConstants.PROC_TASK_FINISHED.END_TASK);
        incOrderProcInst.setFinishTime(new Date());
        this.incOrderModel.updateProcInst(incOrderProcInst);
    }

    private void dealUpdateState(IncOrderTerminateReqBo reqBo) {
        IncOrder incOrder = IncRu.js(reqBo, IncOrder.class);
        incOrder.setIncOrderState("INC_TERMINATION");
        this.incOrderModel.updateIncOrder(incOrder);
        JSONObject object = new JSONObject();
        object.put("incOrderState", (Object)"INC_TERMINATION");
        this.incElasticsearchUtil.updateData(this.INC_ORDER_INDEX_NAME, this.esType, reqBo.getIncOrderId().toString(), object);
    }

    private void validateState(IncOrderTerminateReqBo reqBo) {
        IncOrderQryBO incOrderQryBO = new IncOrderQryBO();
        incOrderQryBO.setIncOrderId(reqBo.getIncOrderId());
        IncOrderDO incOrderDO = this.incOrderModel.qryIncOrderDetail(incOrderQryBO);
        if (ObjectUtil.isEmpty((Object)incOrderDO)) {
            throw new BaseBusinessException("100100", "\u8be2\u4ef7\u5355\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        if ("INC_AUDIT".equals(incOrderDO.getIncOrderState())) {
            throw new BaseBusinessException("100100", "\u5ba1\u6279\u4e2d\u7684\u8be2\u4ef7\u5355\u4e0d\u5141\u8bb8\u7ec8\u6b62\uff01");
        }
    }
}

