/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.quotation;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderDO;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.inquiryorder.qrybo.IncOrderQryBO;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrder;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrderAccessory;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncSupplier;
import com.tydic.dyc.inc.model.quotation.IncQuatationModel;
import com.tydic.dyc.inc.model.quotation.sub.IncQuatation;
import com.tydic.dyc.inc.model.quotation.sub.IncQuatationSkuItem;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderAccessoryBO;
import com.tydic.dyc.inc.service.domainservice.quotation.IncAddBidQuatationService;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncAddBidQuatationReqBO;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncAddBidQuatationRspBO;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncQuatationSkuItemBO;
import com.tydic.dyc.inc.utils.IdUtil;
import com.tydic.dyc.inc.utils.IncRu;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.quotation.IncAddBidQuatationService"})
public class IncAddBidQuatationServiceImpl
implements IncAddBidQuatationService {
    @Autowired
    private IncQuatationModel incQuatationModel;
    @Autowired
    private IncOrderModel incOrderModel;

    @PostMapping(value={"addBidQuatation"})
    public IncAddBidQuatationRspBO addBidQuatation(@RequestBody IncAddBidQuatationReqBO reqBO) {
        IncAddBidQuatationRspBO rsp = IncRu.success(IncAddBidQuatationRspBO.class);
        IncOrderQryBO incOrderQryBO = new IncOrderQryBO();
        incOrderQryBO.setIncOrderId(reqBO.getIncOrderId());
        IncOrderDO incOrderDO = this.incOrderModel.qryIncOrderDetail(incOrderQryBO);
        if (ObjectUtil.isEmpty((Object)incOrderDO)) {
            throw new BaseBusinessException("100100", "\u8be2\u4ef7\u5355\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        if (IncConstants.IncType.INQUIRY.equals(incOrderDO.getIncType())) {
            throw new BaseBusinessException("100100", "\u8be5\u5355\u636e\u4e3a\u8be2\u4ef7\u5355\uff01");
        }
        if (reqBO.getQuatationRound() > incOrderDO.getMaxQuatationNum()) {
            throw new BaseBusinessException("100100", "\u5df2\u8d85\u8fc7\u6700\u5927\u62a5\u4ef7\u6b21\u6570\uff01");
        }
        LocalDateTime quatationTime = LocalDateTime.now();
        if (quatationTime.isAfter(LocalDateTime.ofInstant(incOrderDO.getQuatationEndTime().toInstant(), ZoneId.systemDefault()))) {
            throw new BaseBusinessException("100100", "\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u62a5\u4ef7\uff01");
        }
        Long incQuatationId = this.doQuatation(reqBO, incOrderDO);
        if (ObjectUtil.isNotEmpty((Object)reqBO.getIncQuatationAccessoryBOList())) {
            this.insertAccessorys(reqBO, incQuatationId);
        }
        Date quatationEndTime = this.checkEndTime(incOrderDO, quatationTime, reqBO);
        rsp.setIncQuatationId(incQuatationId);
        rsp.setQuatationEndTime(quatationEndTime);
        return rsp;
    }

    private Date checkEndTime(IncOrderDO incOrderDO, LocalDateTime quatationTime, IncAddBidQuatationReqBO reqBO) {
        if (null == incOrderDO.getAutoDelayValue()) {
            return null;
        }
        LocalDateTime qutationEndTime = LocalDateTime.ofInstant(incOrderDO.getQuatationEndTime().toInstant(), ZoneId.systemDefault());
        if (quatationTime.plusMinutes(5L).isAfter(qutationEndTime)) {
            LocalDateTime newQutationEndTime = qutationEndTime.plusMinutes(incOrderDO.getAutoDelayValue().intValue());
            IncOrder incOrder = new IncOrder();
            incOrder.setIncOrderId(incOrderDO.getIncOrderId());
            incOrder.setQuatationEndTime(Date.from(newQutationEndTime.atZone(ZoneId.systemDefault()).toInstant()));
            incOrder.setUpdateOperId(reqBO.getUserId() + "");
            incOrder.setUpdateOperName(reqBO.getName());
            incOrder.setUpdateTime(new Date());
            this.incOrderModel.updateIncOrder(incOrder);
            return incOrder.getQuatationEndTime();
        }
        return null;
    }

    private void insertAccessorys(IncAddBidQuatationReqBO reqBO, Long incQuatationId) {
        ArrayList<IncOrderAccessory> incOrderAccessories = new ArrayList<IncOrderAccessory>();
        for (IncOrderAccessoryBO bo : reqBO.getIncQuatationAccessoryBOList()) {
            IncOrderAccessory incOrderAccessory = new IncOrderAccessory();
            BeanUtils.copyProperties((Object)bo, (Object)incOrderAccessory);
            incOrderAccessory.setId(IdUtil.nextId());
            incOrderAccessory.setObjId(incQuatationId);
            incOrderAccessory.setObjType(IncConstants.AccessoryObjType.QUATATION);
            incOrderAccessory.setOrderId(reqBO.getIncOrderId());
            incOrderAccessory.setAttachmentType(IncConstants.AccessoryAttachmentType.QUATATION);
            incOrderAccessory.setCreateOperId(reqBO.getUserId().toString());
            incOrderAccessory.setCreateTime(new Date());
            incOrderAccessories.add(incOrderAccessory);
        }
        this.incOrderModel.addOrderAccessoryBatch(incOrderAccessories);
    }

    private Long doQuatation(IncAddBidQuatationReqBO reqBO, IncOrderDO incOrderDO) {
        this.checkQuatation(reqBO);
        this.checkOrAddSupplier(reqBO, incOrderDO);
        this.checkAndUpdateLastQuatationItem(reqBO);
        Long incQuatationId = this.saveQutation(reqBO, incOrderDO);
        this.saveQuatationItem(reqBO, incQuatationId);
        return incQuatationId;
    }

    private void checkOrAddSupplier(IncAddBidQuatationReqBO reqBO, IncOrderDO incOrderDO) {
        if (IncConstants.PurchaseModel.INVITE.equals(incOrderDO.getPurchaseModel())) {
            IncSupplier incSupplier = new IncSupplier();
            incSupplier.setIncOrderId(reqBO.getIncOrderId());
            incSupplier.setSupplierId(reqBO.getSupplierId());
            List<IncSupplier> result = this.incOrderModel.getIncSupplierList(incSupplier);
            if (ObjectUtil.isEmpty(result) || result.size() != 1) {
                throw new BaseBusinessException("100100", "\u67e5\u8be2\u4f9b\u5e94\u5546\u8868\u4e3a\u7a7a\u6216\u6570\u636e\u5b58\u5728\u591a\u6761\uff01");
            }
        } else if (reqBO.getQuatationRound() == 1) {
            IncSupplier incSupplier = new IncSupplier();
            incSupplier.setIncOrderId(reqBO.getIncOrderId());
            incSupplier.setSupplierId(reqBO.getSupplierId());
            List<IncSupplier> result = this.incOrderModel.getIncSupplierList(incSupplier);
            if (ObjectUtil.isNotEmpty(result)) {
                throw new BaseBusinessException("100100", "\u5f53\u524d\u4f9b\u5e94\u5546\u975e\u9996\u8f6e\u62a5\u4ef7\uff01");
            }
            ArrayList<IncSupplier> list = new ArrayList<IncSupplier>();
            IncSupplier addIncSupplier = new IncSupplier();
            BeanUtils.copyProperties((Object)reqBO, (Object)addIncSupplier);
            addIncSupplier.setIncSupplierId(IdUtil.nextId());
            addIncSupplier.setIncOrderId(reqBO.getIncOrderId());
            addIncSupplier.setCreateOperId(reqBO.getUserId().toString());
            addIncSupplier.setCreateOperName(reqBO.getName());
            addIncSupplier.setCreateTime(new Date());
            list.add(addIncSupplier);
            this.incOrderModel.addIncSupplierBatch(list);
        }
    }

    private void checkQuatation(IncAddBidQuatationReqBO reqBO) {
        IncQuatation incQuatation = new IncQuatation();
        incQuatation.setIncOrderId(reqBO.getIncOrderId());
        incQuatation.setSupplierId(reqBO.getSupplierId());
        incQuatation.setQuatationRound(reqBO.getQuatationRound());
        List<IncQuatation> result = this.incQuatationModel.getQuatationList(incQuatation);
        if (ObjectUtil.isNotEmpty(result)) {
            throw new BaseBusinessException("100100", "\u5f53\u524d\u8f6e\u6b21\u5df2\u62a5\u8fc7\u4ef7\uff01");
        }
    }

    private void saveQuatationItem(IncAddBidQuatationReqBO reqBO, Long incQuatationId) {
        ArrayList<IncQuatationSkuItem> list = new ArrayList<IncQuatationSkuItem>();
        for (IncQuatationSkuItemBO bo : reqBO.getIncQuatationSkuItemBOList()) {
            IncQuatationSkuItem incQuatationSkuItem = new IncQuatationSkuItem();
            BeanUtils.copyProperties((Object)bo, (Object)incQuatationSkuItem);
            incQuatationSkuItem.setIncQuatationSkuItemId(IdUtil.nextId());
            incQuatationSkuItem.setIncQuatationId(incQuatationId);
            incQuatationSkuItem.setIncOrderId(reqBO.getIncOrderId());
            incQuatationSkuItem.setQuatationSkuItemState("1");
            incQuatationSkuItem.setCreateOperId(reqBO.getUserId() + "");
            incQuatationSkuItem.setCreateOperName(reqBO.getName());
            incQuatationSkuItem.setCreateTime(new Date());
            list.add(incQuatationSkuItem);
        }
        this.incQuatationModel.insertQuatationSkuItemBatch(list);
    }

    private Long saveQutation(IncAddBidQuatationReqBO reqBO, IncOrderDO incOrderDO) {
        Long incQuatationId = IdUtil.nextId();
        IncQuatation incQuatation = new IncQuatation();
        BeanUtils.copyProperties((Object)reqBO, (Object)incQuatation);
        incQuatation.setIncQuatationId(incQuatationId);
        incQuatation.setQuatationState("2");
        incQuatation.setQuatationStartTime(incOrderDO.getQuatationStartTime());
        incQuatation.setQuatationEndTime(incOrderDO.getQuatationEndTime());
        incQuatation.setCreateOperId(reqBO.getUserId() + "");
        incQuatation.setCreateOperName(reqBO.getName());
        incQuatation.setCreateTime(new Date());
        this.incQuatationModel.insertQutation(incQuatation);
        return incQuatationId;
    }

    private void checkAndUpdateLastQuatationItem(IncAddBidQuatationReqBO reqBO) {
        for (IncQuatationSkuItemBO bo : reqBO.getIncQuatationSkuItemBOList()) {
            List<IncQuatationSkuItem> result;
            IncQuatationSkuItem incQuatationSkuItem;
            if (ObjectUtil.isNull((Object)bo.getLastIncQuatationSkuItemId())) {
                incQuatationSkuItem = new IncQuatationSkuItem();
                incQuatationSkuItem.setInsSkuItemId(bo.getInsSkuItemId());
                incQuatationSkuItem.setQuatationSkuItemState("1");
                result = this.incQuatationModel.getQuatationSkuItemList(incQuatationSkuItem);
                if (!ObjectUtil.isNotEmpty(result)) continue;
                throw new BaseBusinessException("100100", "\u5b58\u5728\u66f4\u65b0\u7684\u62a5\u4ef7\uff0c\u5f53\u524d\u62a5\u4ef7\u5931\u6548\uff01");
            }
            incQuatationSkuItem = new IncQuatationSkuItem();
            incQuatationSkuItem.setInsSkuItemId(bo.getInsSkuItemId());
            incQuatationSkuItem.setQuatationSkuItemState("1");
            result = this.incQuatationModel.getQuatationSkuItemList(incQuatationSkuItem);
            if (ObjectUtil.isEmpty(result)) {
                throw new BaseBusinessException("100100", "\u62a5\u4ef7\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a\uff01");
            }
            if (result.size() != 1 || !result.get(0).getIncQuatationSkuItemId().equals(bo.getLastIncQuatationSkuItemId())) {
                throw new BaseBusinessException("100100", "\u5b58\u5728\u66f4\u65b0\u7684\u62a5\u4ef7\uff0c\u5f53\u524d\u62a5\u4ef7\u5931\u6548\uff01");
            }
            IncQuatationSkuItem updateIncQuatationSkuItem = new IncQuatationSkuItem();
            updateIncQuatationSkuItem.setIncQuatationSkuItemId(bo.getLastIncQuatationSkuItemId());
            updateIncQuatationSkuItem.setQuatationSkuItemState("2");
            updateIncQuatationSkuItem.setUpdateOperId(reqBO.getUserId() + "");
            updateIncQuatationSkuItem.setUpdateOperName(reqBO.getName());
            updateIncQuatationSkuItem.setUpdateTime(new Date());
            this.incQuatationModel.updateQuatationSkuItem(updateIncQuatationSkuItem);
        }
    }
}

