/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.quotation;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncQuotation;
import com.tydic.dyc.inc.model.quotation.IncQuatationModel;
import com.tydic.dyc.inc.model.quotation.sub.IncQuatation;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.quotation.IncRecallQuotationService;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncRecallQuotationReqBO;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncRecallQuotationRspBO;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.quotation.IncRecallQuotationService"})
public class IncRecallQuotationServiceImpl
implements IncRecallQuotationService {
    @Autowired
    private IncQuatationModel incQuatationModel;

    @PostMapping(value={"recallQuotation"})
    public IncRecallQuotationRspBO recallQuotation(@RequestBody IncRecallQuotationReqBO reqBO) {
        this.validateParam(reqBO);
        this.incQuatationModel.updateIncQuotation(IncRu.js(reqBO, IncQuotation.class));
        return IncRu.success(IncRecallQuotationRspBO.class);
    }

    private void validateParam(IncRecallQuotationReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u8be2\u4ef7\u5355\u64a4\u56de\u62a5\u4ef7\u5931\u8d25\uff1a\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getIncQuatationId())) {
            throw new ZTBusinessException("\u8be2\u4ef7\u5355\u64a4\u56de\u62a5\u4ef7\u5931\u8d25\uff1a\u5165\u53c2\u64a4\u56de\u62a5\u4ef7\u5355ID\u3010incQuatationId\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getWithdrawQuatationDesc())) {
            throw new ZTBusinessException("\u8be2\u4ef7\u5355\u64a4\u56de\u62a5\u4ef7\u5931\u8d25\uff1a\u5165\u53c2\u64a4\u56de\u62a5\u4ef7\u8bf4\u660e\u3010withdrawQuatationDesc\u3011\u4e3a\u7a7a");
        }
        IncQuatation quatation = new IncQuatation();
        quatation.setIncQuatationId(reqBO.getIncQuatationId());
        quatation.setDelTag(IncConstants.DelTag.NO);
        List<IncQuatation> list = this.incQuatationModel.getQuatationList(quatation);
        if (CollectionUtil.isEmpty(list)) {
            throw new ZTBusinessException("\u8be2\u4ef7\u5355\u64a4\u56de\u62a5\u4ef7\u5931\u8d25\uff1a\u8be5\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728");
        }
    }
}

