/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.rule;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.inc.model.rule.IncRuleDO;
import com.tydic.dyc.inc.model.rule.IncRuleModel;
import com.tydic.dyc.inc.model.rule.qrybo.IncRuleQryBO;
import com.tydic.dyc.inc.model.rule.sub.IncCheckRuleApp;
import com.tydic.dyc.inc.model.sysdictionary.IncSysDicDictionaryModel;
import com.tydic.dyc.inc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.rule.IncConfRuleQryDetailService;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncConfRuleQryDetailReqBo;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncConfRuleQryDetailRspBo;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.rule.IncConfRuleQryDetailService"})
public class IncConfRuleQryDetailServiceImpl
implements IncConfRuleQryDetailService {
    @Autowired
    private IncRuleModel incRuleModel;
    @Autowired
    private IncSysDicDictionaryModel incSysDicDictionaryModel;

    @PostMapping(value={"qryRuleDetail"})
    public IncConfRuleQryDetailRspBo qryRuleDetail(@RequestBody IncConfRuleQryDetailReqBo reqBo) {
        if (reqBo.getConfId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u914d\u7f6eID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IncRuleQryBO incRuleQryBO = IncRu.js(reqBo, IncRuleQryBO.class);
        incRuleQryBO.setDelTag(IncConstants.DELETE_TAG.NO_DEL);
        IncRuleDO incRuleDO = this.incRuleModel.qryRuleDetail(incRuleQryBO);
        IncConfRuleQryDetailRspBo rspBo = IncRu.js(incRuleDO, IncConfRuleQryDetailRspBo.class);
        this.transField(rspBo);
        return rspBo;
    }

    @PostMapping(value={"qryruleDetailByOrgId"})
    public IncConfRuleQryDetailRspBo qryruleDetailByOrgId(@RequestBody IncConfRuleQryDetailReqBo reqBo) {
        if (StringUtils.isEmpty((CharSequence)reqBo.getOrgPath())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u4f7f\u7528\u5355\u4f4d\u673a\u6784\u8def\u5f84]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getConfType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u89c4\u5219\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IncRuleQryBO incRuleQryBO = IncRu.js(reqBo, IncRuleQryBO.class);
        incRuleQryBO.setOrgId(reqBo.getRuleOrgId());
        incRuleQryBO.setDelTag(IncConstants.DELETE_TAG.NO_DEL);
        IncCheckRuleApp incCheckRuleApp = this.incRuleModel.qryRuleConfByOrgPath(incRuleQryBO);
        if (incCheckRuleApp == null) {
            throw new BaseBusinessException("100001", "\u672a\u914d\u7f6e\u76f8\u5e94\u89c4\u5219\uff0c\u8bf7\u6838\u67e5\u3002");
        }
        incRuleQryBO = new IncRuleQryBO();
        incRuleQryBO.setConfId(incCheckRuleApp.getConfId());
        incRuleQryBO.setDelTag(IncConstants.DELETE_TAG.NO_DEL);
        IncRuleDO incRuleDO = this.incRuleModel.qryRuleDetail(incRuleQryBO);
        IncConfRuleQryDetailRspBo rspBo = IncRu.js(incRuleDO, IncConfRuleQryDetailRspBo.class);
        this.transField(rspBo);
        return rspBo;
    }

    private void transField(IncConfRuleQryDetailRspBo rspBo) {
        Map<String, String> confType = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "CONF_TYPE")).getMap();
        Map<String, String> ifFlag = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "IF_FLAG")).getMap();
        Map<String, String> xjPurType = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "XJ_PUR_TYPE")).getMap();
        Map<String, String> jjPurType = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "JJ_PUR_TYPE")).getMap();
        rspBo.setConfTypeStr(confType.get(rspBo.getConfType()));
        if (StringUtils.isNotBlank((CharSequence)rspBo.getBargainFlag())) {
            rspBo.setBargainFlagStr(ifFlag.get(rspBo.getBargainFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)rspBo.getForceFlag())) {
            rspBo.setForceFlagStr(ifFlag.get(rspBo.getForceFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)rspBo.getPurType())) {
            if ("1".equals(rspBo.getConfType())) {
                this.setPurTypeStr(rspBo, xjPurType);
            } else if ("2".equals(rspBo.getConfType())) {
                this.setPurTypeStr(rspBo, jjPurType);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)rspBo.getMissFlag())) {
            rspBo.setMissFlagStr(ifFlag.get(rspBo.getMissFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)rspBo.getRegisFlag())) {
            rspBo.setRegisFlagStr(ifFlag.get(rspBo.getRegisFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)rspBo.getDecreaseFlag())) {
            rspBo.setDecreaseFlagStr(ifFlag.get(rspBo.getDecreaseFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)rspBo.getAutodelayFlag())) {
            rspBo.setAutodelayFlagStr(ifFlag.get(rspBo.getAutodelayFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)rspBo.getMaxtimesFlag())) {
            rspBo.setMaxtimesFlagStr(ifFlag.get(rspBo.getMaxtimesFlag()));
        }
    }

    private void setPurTypeStr(IncConfRuleQryDetailRspBo rspBo, Map<String, String> dicMap) {
        if (rspBo.getPurType().contains(",")) {
            String[] purTypeArr = rspBo.getPurType().split(",");
            ArrayList<String> purTypeStr = new ArrayList<String>();
            for (String str : purTypeArr) {
                purTypeStr.add(dicMap.get(str));
            }
            rspBo.setPurTypeStr(String.join((CharSequence)",", purTypeStr));
        } else {
            rspBo.setPurTypeStr(dicMap.get(rspBo.getPurType()));
        }
    }
}

