/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.rule;

import com.tydic.dyc.inc.model.rule.IncRuleModel;
import com.tydic.dyc.inc.model.rule.qrybo.IncRuleListQryBO;
import com.tydic.dyc.inc.model.rule.qrybo.IncRuleQryRspBO;
import com.tydic.dyc.inc.model.sysdictionary.IncSysDicDictionaryModel;
import com.tydic.dyc.inc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.inc.service.domainservice.rule.IncConfRuleQryListService;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncConfRuleListBO;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncConfRuleQryListReqBo;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncConfRuleQryListRspBo;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.rule.IncConfRuleQryListService"})
public class IncConfRuleQryListServiceImpl
implements IncConfRuleQryListService {
    @Autowired
    private IncRuleModel incRuleModel;
    @Autowired
    private IncSysDicDictionaryModel incSysDicDictionaryModel;

    @PostMapping(value={"qryRuleListPage"})
    public IncConfRuleQryListRspBo qryRuleListPage(@RequestBody IncConfRuleQryListReqBo reqBo) {
        IncConfRuleQryListRspBo rspBO = IncRu.success(IncConfRuleQryListRspBo.class);
        IncRuleListQryBO incRuleListQryBO = new IncRuleListQryBO();
        IncRuleQryRspBO incRuleQryRspBO = this.incRuleModel.qryRuleListPage(incRuleListQryBO);
        if (CollectionUtils.isEmpty((Collection)incRuleQryRspBO.getRows())) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        List<IncConfRuleListBO> jsl = IncRu.jsl(incRuleQryRspBO.getRows(), IncConfRuleListBO.class);
        this.transferRspBo(jsl);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRecordsTotal(incRuleQryRspBO.getRecordsTotal());
        rspBO.setTotal(incRuleQryRspBO.getTotal());
        rspBO.setPageNo(incRuleQryRspBO.getPageNo());
        rspBO.setRows(jsl);
        return rspBO;
    }

    private void transferRspBo(List<IncConfRuleListBO> incConfRuleListBOS) {
        Map<String, String> ifFlag = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "IF_FLAG")).getMap();
        Map<String, String> skuScope = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "SKU_SCOPE")).getMap();
        Map<String, String> xjPurType = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "XJ_PUR_TYPE")).getMap();
        Map<String, String> jjPurType = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "JJ_PUR_TYPE")).getMap();
        incConfRuleListBOS.forEach(item -> {
            if (StringUtils.isNotBlank((String)item.getBargainFlag())) {
                item.setBargainFlagStr((String)ifFlag.get(item.getBargainFlag()));
            }
            if (StringUtils.isNotBlank((String)item.getForceFlag())) {
                item.setForceFlagStr((String)ifFlag.get(item.getForceFlag()));
            }
            if (StringUtils.isNotBlank((String)item.getSkuScope())) {
                if (item.getSkuScope().contains(",")) {
                    String[] skuScopeArr = item.getSkuScope().split(",");
                    ArrayList skuScopeStr = new ArrayList();
                    for (String str : skuScopeArr) {
                        skuScopeStr.add(skuScope.get(str));
                    }
                    item.setSkuScope(String.join((CharSequence)",", skuScopeStr));
                } else {
                    item.setSkuScope((String)skuScope.get(item.getSkuScope()));
                }
            }
            if (item.getDelTag() == 0) {
                item.setDelTagStr("\u542f\u7528");
            } else if (item.getDelTag() == 1) {
                item.setDelTagStr("\u505c\u7528");
            }
            if (StringUtils.isNotBlank((String)item.getPurType())) {
                if (item.getPurType().contains(",")) {
                    String[] purTypeArr = item.getPurType().split(",");
                    ArrayList purTypeStr = new ArrayList();
                    for (String str : purTypeArr) {
                        if ("1".equals(item.getConfType())) {
                            purTypeStr.add(xjPurType.get(str));
                            continue;
                        }
                        if (!"2".equals(item.getConfType())) continue;
                        purTypeStr.add(jjPurType.get(str));
                    }
                    item.setPurTypeStr(String.join((CharSequence)",", purTypeStr));
                } else if ("1".equals(item.getConfType())) {
                    item.setSkuScope((String)xjPurType.get(item.getSkuScope()));
                } else if ("2".equals(item.getConfType())) {
                    item.setSkuScope((String)jjPurType.get(item.getSkuScope()));
                }
            }
            if (StringUtils.isNotBlank((String)item.getMissFlag())) {
                item.setMissFlagStr((String)ifFlag.get(item.getMissFlag()));
            }
            if (StringUtils.isNotBlank((String)item.getRegisFlag())) {
                item.setRegisFlagStr((String)ifFlag.get(item.getRegisFlag()));
            }
            if (StringUtils.isNotBlank((String)item.getDecreaseFlag())) {
                item.setDecreaseFlagStr((String)ifFlag.get(item.getDecreaseFlag()));
            }
            if (StringUtils.isNotBlank((String)item.getAutodelayFlag())) {
                item.setAutodelayFlagStr((String)ifFlag.get(item.getAutodelayFlag()));
            }
            if (StringUtils.isNotBlank((String)item.getMaxtimesFlag())) {
                item.setMaxtimesFlagStr((String)ifFlag.get(item.getMaxtimesFlag()));
            }
        });
    }
}

