/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.rule;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.inc.model.rule.IncRuleDO;
import com.tydic.dyc.inc.model.rule.IncRuleModel;
import com.tydic.dyc.inc.model.rule.qrybo.IncRuleQryBO;
import com.tydic.dyc.inc.model.rule.sub.IncCheckRuleApp;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.rule.IncDealSkuTriggerRuleJudgeService;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncConfRuleDivisorBo;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncConfRuleGroupBo;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncConfRuleItemBo;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncDealSkuTriggerRuleJudgeReqBo;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncDealSkuTriggerRuleJudgeRspBo;
import com.tydic.dyc.inc.service.domainservice.rule.bo.IncRuleTriggerSkuBo;
import com.tydic.dyc.inc.utils.IncRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.rule.IncDealSkuTriggerRuleJudgeService"})
public class IncDealSkuTriggerRuleJudgeServiceImpl
implements IncDealSkuTriggerRuleJudgeService {
    private static final Logger log = LoggerFactory.getLogger(IncDealSkuTriggerRuleJudgeServiceImpl.class);
    @Autowired
    private IncRuleModel incRuleModel;

    @PostMapping(value={"checkIfTriggerRule"})
    public IncDealSkuTriggerRuleJudgeRspBo checkIfTriggerRule(@RequestBody IncDealSkuTriggerRuleJudgeReqBo reqBo) {
        IncRuleDO jjRuleInfo;
        IncDealSkuTriggerRuleJudgeRspBo rspBo = IncRu.success(IncDealSkuTriggerRuleJudgeRspBo.class);
        ArrayList<Long> jjSkuList = new ArrayList<Long>();
        ArrayList<Long> yjSkuList = new ArrayList<Long>();
        ArrayList<Long> orderSkuList = new ArrayList<Long>();
        IncCheckRuleApp jjRule = this.qryRule(reqBo.getOrgPath(), "2");
        if (jjRule != null && !CollectionUtils.isEmpty((jjRuleInfo = this.qryRuleDetail(jjRule.getConfId())).getRuleItemBos())) {
            Map<Long, String> skuExpMap = this.judgeRule(jjRuleInfo.getRuleItemBos().get(0), reqBo.getSkuBos(), reqBo.getSkuBos());
            for (Map.Entry<Long, String> entry : skuExpMap.entrySet()) {
                if (this.executExp(entry.getValue())) {
                    jjSkuList.add(entry.getKey());
                    continue;
                }
                orderSkuList.add(entry.getKey());
            }
        }
        log.info("jjSkuList\u7684\u503c\u4e3a\uff1a" + JSON.toJSONString(jjSkuList));
        List<Object> resultSkuBos = new ArrayList();
        resultSkuBos = !CollectionUtils.isEmpty(jjSkuList) ? reqBo.getSkuBos().stream().filter(obj -> !jjSkuList.contains(obj.getSkuId())).collect(Collectors.toList()) : reqBo.getSkuBos();
        log.info("resultSkuBos\u7684\u503c\u4e3a\uff1a" + JSON.toJSONString(resultSkuBos));
        IncCheckRuleApp yjRule = this.qryRule(reqBo.getOrgPath(), "3");
        if (yjRule != null) {
            IncRuleDO yjRuleInfo = this.qryRuleDetail(yjRule.getConfId());
            if (!CollectionUtils.isEmpty(yjRuleInfo.getRuleItemBos())) {
                Map<Long, String> yjSkuExpMap = this.judgeRule(yjRuleInfo.getRuleItemBos().get(0), reqBo.getSkuBos(), resultSkuBos);
                orderSkuList.clear();
                for (Map.Entry<Long, String> entry : yjSkuExpMap.entrySet()) {
                    if (this.executExp(entry.getValue())) {
                        yjSkuList.add(entry.getKey());
                        continue;
                    }
                    orderSkuList.add(entry.getKey());
                }
            }
        } else {
            orderSkuList.clear();
            orderSkuList.addAll(resultSkuBos.stream().map(IncRuleTriggerSkuBo::getSkuId).collect(Collectors.toList()));
        }
        rspBo.setJjSkuList(jjSkuList);
        rspBo.setYjSkuList(yjSkuList);
        rspBo.setOrderSkuList(orderSkuList);
        return rspBo;
    }

    private IncCheckRuleApp qryRule(String orgPath, String confType) {
        IncRuleQryBO incRuleQryBO = new IncRuleQryBO();
        incRuleQryBO.setOrgPath(orgPath);
        incRuleQryBO.setDelTag(IncConstants.DELETE_TAG.NO_DEL);
        incRuleQryBO.setConfType(confType);
        return this.incRuleModel.qryRuleConfByOrgPath(incRuleQryBO);
    }

    private IncRuleDO qryRuleDetail(Long confId) {
        IncRuleQryBO incRuleQryBO = new IncRuleQryBO();
        incRuleQryBO.setConfId(confId);
        incRuleQryBO.setDelTag(IncConstants.DELETE_TAG.NO_DEL);
        return this.incRuleModel.qryRuleDetail(incRuleQryBO);
    }

    private Map<Long, String> judgeRule(IncConfRuleItemBo itemBo, List<IncRuleTriggerSkuBo> skuBos, List<IncRuleTriggerSkuBo> resultSkuBos) {
        HashMap<Long, String> skuExpressionMap = new HashMap<Long, String>();
        List ruleGroupBos = itemBo.getRuleGroupBos();
        for (IncConfRuleGroupBo groupBo : ruleGroupBos) {
            for (int i = 0; i < groupBo.getRuleDivisorBos().size(); ++i) {
                IncConfRuleDivisorBo divisorBo = (IncConfRuleDivisorBo)groupBo.getRuleDivisorBos().get(i);
                if ("1".equals(divisorBo.getSource()) && "1".equals(divisorBo.getDivisor())) {
                    this.dealSkuPriceJudgeFunc(skuExpressionMap, resultSkuBos, divisorBo, i, groupBo.getRuleDivisorBos().size(), groupBo.getGroupRelation());
                    continue;
                }
                if ("1".equals(divisorBo.getSource()) && "2".equals(divisorBo.getDivisor())) {
                    this.dealSkuTotalAmtJudgeFunc(skuExpressionMap, resultSkuBos, divisorBo, i, groupBo.getRuleDivisorBos().size(), groupBo.getGroupRelation());
                    continue;
                }
                if ("1".equals(divisorBo.getSource()) && "3".equals(divisorBo.getDivisor())) {
                    this.dealSkuNumJudgeFunc(skuExpressionMap, resultSkuBos, divisorBo, i, groupBo.getRuleDivisorBos().size(), groupBo.getGroupRelation());
                    continue;
                }
                if ("2".equals(divisorBo.getSource()) && "2".equals(divisorBo.getDivisor())) {
                    this.dealCommodityTotalAmtJudgeFunc(skuExpressionMap, skuBos, divisorBo, resultSkuBos, i, groupBo.getRuleDivisorBos().size(), groupBo.getGroupRelation());
                    continue;
                }
                if ("2".equals(divisorBo.getSource()) && "3".equals(divisorBo.getDivisor())) {
                    this.dealCommodityNumJudgeFunc(skuExpressionMap, skuBos, divisorBo, resultSkuBos, i, groupBo.getRuleDivisorBos().size(), groupBo.getGroupRelation());
                    continue;
                }
                if ("3".equals(divisorBo.getSource()) && "2".equals(divisorBo.getDivisor())) {
                    this.dealSupTotalAmtJudgeFunc(skuExpressionMap, skuBos, divisorBo, resultSkuBos, i, groupBo.getRuleDivisorBos().size(), groupBo.getGroupRelation());
                    continue;
                }
                if ("3".equals(divisorBo.getSource()) && "3".equals(divisorBo.getDivisor())) {
                    this.dealSupNumJudgeFunc(skuExpressionMap, skuBos, divisorBo, resultSkuBos, i, groupBo.getRuleDivisorBos().size(), groupBo.getGroupRelation());
                    continue;
                }
                if ("4".equals(divisorBo.getSource()) && "2".equals(divisorBo.getDivisor())) {
                    this.dealBrandAmtJudgeFunc(skuExpressionMap, skuBos, divisorBo, resultSkuBos, i, groupBo.getRuleDivisorBos().size(), groupBo.getGroupRelation());
                    continue;
                }
                if ("4".equals(divisorBo.getSource()) && "3".equals(divisorBo.getDivisor())) {
                    this.dealBrandNumJudgeFunc(skuExpressionMap, skuBos, divisorBo, resultSkuBos, i, groupBo.getRuleDivisorBos().size(), groupBo.getGroupRelation());
                    continue;
                }
                if (!"5".equals(divisorBo.getSource()) || !"4".equals(divisorBo.getDivisor())) continue;
                this.dealCatlogContainJudgeFunc(skuExpressionMap, resultSkuBos, divisorBo, i, groupBo.getRuleDivisorBos().size(), groupBo.getGroupRelation());
            }
        }
        return skuExpressionMap;
    }

    private boolean isJudge(BigDecimal sourceValue, String condition, String destValue) {
        switch (condition) {
            case ">": {
                return sourceValue.compareTo(new BigDecimal(destValue)) > 0;
            }
            case ">=": {
                return sourceValue.compareTo(new BigDecimal(destValue)) >= 0;
            }
        }
        return false;
    }

    private StringBuffer replaceLogicRelation(String relation, StringBuffer judgeResult) {
        if (StringUtils.isNotBlank((CharSequence)relation)) {
            if ("AND".equals(relation)) {
                judgeResult.append("&&");
            } else if ("OR".equals(relation)) {
                judgeResult.append("||");
            }
        }
        return judgeResult;
    }

    private void assemableFirstGroupInfo(int i, int size, String relation, StringBuffer judgeResult) {
        if (i == 0) {
            if (StringUtils.isNotBlank((CharSequence)relation)) {
                if ("AND".equals(relation)) {
                    judgeResult.append("&&");
                } else if ("OR".equals(relation)) {
                    judgeResult.append("||");
                }
            }
            judgeResult.append("(");
        }
    }

    private void assemableEndGroupInfo(int i, int size, String relation, StringBuffer judgeResult) {
        if (i == size - 1) {
            judgeResult.append(")");
        }
    }

    private void dealSkuPriceJudgeFunc(Map<Long, String> skuExpressionMap, List<IncRuleTriggerSkuBo> skuBos, IncConfRuleDivisorBo divisorBo, int i, int size, String relation) {
        skuBos.forEach(sku -> {
            StringBuffer judgeResult = null;
            judgeResult = skuExpressionMap.containsKey(sku.getSkuId()) ? new StringBuffer((String)skuExpressionMap.get(sku.getSkuId())) : new StringBuffer();
            this.assemableFirstGroupInfo(i, size, relation, judgeResult);
            judgeResult = this.replaceLogicRelation(divisorBo.getRelation(), judgeResult);
            judgeResult.append(this.isJudge(sku.getPrice(), divisorBo.getJudgment(), divisorBo.getValue()));
            this.assemableEndGroupInfo(i, size, relation, judgeResult);
            skuExpressionMap.put(sku.getSkuId(), judgeResult.toString());
        });
    }

    private void dealSkuTotalAmtJudgeFunc(Map<Long, String> skuExpressionMap, List<IncRuleTriggerSkuBo> skuBos, IncConfRuleDivisorBo divisorBo, int i, int size, String relation) {
        skuBos.forEach(sku -> {
            StringBuffer judgeResult = null;
            judgeResult = skuExpressionMap.containsKey(sku.getSkuId()) ? new StringBuffer((String)skuExpressionMap.get(sku.getSkuId())) : new StringBuffer();
            this.assemableFirstGroupInfo(i, size, relation, judgeResult);
            judgeResult = this.replaceLogicRelation(divisorBo.getRelation(), judgeResult);
            judgeResult.append(this.isJudge(sku.getAmt(), divisorBo.getJudgment(), divisorBo.getValue()));
            this.assemableEndGroupInfo(i, size, relation, judgeResult);
            skuExpressionMap.put(sku.getSkuId(), judgeResult.toString());
        });
    }

    private void dealSkuNumJudgeFunc(Map<Long, String> skuExpressionMap, List<IncRuleTriggerSkuBo> skuBos, IncConfRuleDivisorBo divisorBo, int i, int size, String relation) {
        skuBos.forEach(sku -> {
            StringBuffer judgeResult = null;
            judgeResult = skuExpressionMap.containsKey(sku.getSkuId()) ? new StringBuffer((String)skuExpressionMap.get(sku.getSkuId())) : new StringBuffer();
            this.assemableFirstGroupInfo(i, size, relation, judgeResult);
            judgeResult = this.replaceLogicRelation(divisorBo.getRelation(), judgeResult);
            judgeResult.append(this.isJudge(sku.getNum(), divisorBo.getJudgment(), divisorBo.getValue()));
            this.assemableEndGroupInfo(i, size, relation, judgeResult);
            skuExpressionMap.put(sku.getSkuId(), judgeResult.toString());
        });
    }

    private void dealCommodityTotalAmtJudgeFunc(Map<Long, String> skuExpressionMap, List<IncRuleTriggerSkuBo> skuBos, IncConfRuleDivisorBo divisorBo, List<IncRuleTriggerSkuBo> resultSkuBos, int i, int size, String relation) {
        Map<Long, List<IncRuleTriggerSkuBo>> skuCommodityMap = skuBos.stream().collect(Collectors.groupingBy(IncRuleTriggerSkuBo::getCommodityId));
        HashMap<Long, BigDecimal> skuCommodityAmtMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, List<IncRuleTriggerSkuBo>> entry : skuCommodityMap.entrySet()) {
            skuCommodityAmtMap.put(entry.getKey(), entry.getValue().stream().map(IncRuleTriggerSkuBo::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        HashMap commodityResultMap = new HashMap();
        for (Map.Entry entry : skuCommodityAmtMap.entrySet()) {
            if (this.isJudge((BigDecimal)entry.getValue(), divisorBo.getJudgment(), divisorBo.getValue())) {
                commodityResultMap.put(entry.getKey(), true);
                continue;
            }
            commodityResultMap.put(entry.getKey(), false);
        }
        resultSkuBos.forEach(sku -> {
            StringBuffer judgeResult = null;
            judgeResult = skuExpressionMap.containsKey(sku.getSkuId()) ? new StringBuffer((String)skuExpressionMap.get(sku.getSkuId())) : new StringBuffer();
            this.assemableFirstGroupInfo(i, size, relation, judgeResult);
            judgeResult = this.replaceLogicRelation(divisorBo.getRelation(), judgeResult);
            if (commodityResultMap.containsKey(sku.getCommodityId())) {
                judgeResult.append(commodityResultMap.get(sku.getCommodityId()));
            }
            this.assemableEndGroupInfo(i, size, relation, judgeResult);
            skuExpressionMap.put(sku.getSkuId(), judgeResult.toString());
        });
    }

    private void dealCommodityNumJudgeFunc(Map<Long, String> skuExpressionMap, List<IncRuleTriggerSkuBo> skuBos, IncConfRuleDivisorBo divisorBo, List<IncRuleTriggerSkuBo> resultSkuBos, int i, int size, String relation) {
        Map<Long, List<IncRuleTriggerSkuBo>> skuCommodityMap = skuBos.stream().collect(Collectors.groupingBy(IncRuleTriggerSkuBo::getCommodityId));
        HashMap<Long, BigDecimal> skuCommodityNumMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, List<IncRuleTriggerSkuBo>> entry : skuCommodityMap.entrySet()) {
            skuCommodityNumMap.put(entry.getKey(), entry.getValue().stream().map(IncRuleTriggerSkuBo::getNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        HashMap commodityNumResultMap = new HashMap();
        for (Map.Entry entry : skuCommodityNumMap.entrySet()) {
            if (this.isJudge((BigDecimal)entry.getValue(), divisorBo.getJudgment(), divisorBo.getValue())) {
                commodityNumResultMap.put(entry.getKey(), true);
                continue;
            }
            commodityNumResultMap.put(entry.getKey(), false);
        }
        resultSkuBos.forEach(sku -> {
            StringBuffer judgeResult = null;
            judgeResult = skuExpressionMap.containsKey(sku.getSkuId()) ? new StringBuffer((String)skuExpressionMap.get(sku.getSkuId())) : new StringBuffer();
            this.assemableFirstGroupInfo(i, size, relation, judgeResult);
            judgeResult = this.replaceLogicRelation(divisorBo.getRelation(), judgeResult);
            if (commodityNumResultMap.containsKey(sku.getCommodityId())) {
                judgeResult.append(commodityNumResultMap.get(sku.getCommodityId()));
            }
            this.assemableEndGroupInfo(i, size, relation, judgeResult);
            skuExpressionMap.put(sku.getSkuId(), judgeResult.toString());
        });
    }

    private void dealSupTotalAmtJudgeFunc(Map<Long, String> skuExpressionMap, List<IncRuleTriggerSkuBo> skuBos, IncConfRuleDivisorBo divisorBo, List<IncRuleTriggerSkuBo> resultSkuBos, int i, int size, String relation) {
        Map<Long, List<IncRuleTriggerSkuBo>> skuSupMap = skuBos.stream().collect(Collectors.groupingBy(IncRuleTriggerSkuBo::getSupId));
        HashMap<Long, BigDecimal> skuSupAmtMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, List<IncRuleTriggerSkuBo>> entry : skuSupMap.entrySet()) {
            skuSupAmtMap.put(entry.getKey(), entry.getValue().stream().map(IncRuleTriggerSkuBo::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        HashMap supAmtResultMap = new HashMap();
        for (Map.Entry entry : skuSupAmtMap.entrySet()) {
            if (this.isJudge((BigDecimal)entry.getValue(), divisorBo.getJudgment(), divisorBo.getValue())) {
                supAmtResultMap.put(entry.getKey(), true);
                continue;
            }
            supAmtResultMap.put(entry.getKey(), false);
        }
        resultSkuBos.forEach(sku -> {
            StringBuffer judgeResult = null;
            judgeResult = skuExpressionMap.containsKey(sku.getSkuId()) ? new StringBuffer((String)skuExpressionMap.get(sku.getSkuId())) : new StringBuffer();
            this.assemableFirstGroupInfo(i, size, relation, judgeResult);
            judgeResult = this.replaceLogicRelation(divisorBo.getRelation(), judgeResult);
            if (supAmtResultMap.containsKey(sku.getSupId())) {
                judgeResult.append(supAmtResultMap.get(sku.getSupId()));
            }
            this.assemableEndGroupInfo(i, size, relation, judgeResult);
            skuExpressionMap.put(sku.getSkuId(), judgeResult.toString());
        });
    }

    private void dealSupNumJudgeFunc(Map<Long, String> skuExpressionMap, List<IncRuleTriggerSkuBo> skuBos, IncConfRuleDivisorBo divisorBo, List<IncRuleTriggerSkuBo> resultSkuBos, int i, int size, String relation) {
        Map<Long, List<IncRuleTriggerSkuBo>> skuSupMap = skuBos.stream().collect(Collectors.groupingBy(IncRuleTriggerSkuBo::getSupId));
        HashMap<Long, BigDecimal> skuSupNumMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, List<IncRuleTriggerSkuBo>> entry : skuSupMap.entrySet()) {
            skuSupNumMap.put(entry.getKey(), entry.getValue().stream().map(IncRuleTriggerSkuBo::getNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        HashMap supNumResultMap = new HashMap();
        for (Map.Entry entry : skuSupNumMap.entrySet()) {
            if (this.isJudge((BigDecimal)entry.getValue(), divisorBo.getJudgment(), divisorBo.getValue())) {
                supNumResultMap.put(entry.getKey(), true);
                continue;
            }
            supNumResultMap.put(entry.getKey(), false);
        }
        resultSkuBos.forEach(sku -> {
            StringBuffer judgeResult = null;
            judgeResult = skuExpressionMap.containsKey(sku.getSkuId()) ? new StringBuffer((String)skuExpressionMap.get(sku.getSkuId())) : new StringBuffer();
            this.assemableFirstGroupInfo(i, size, relation, judgeResult);
            judgeResult = this.replaceLogicRelation(divisorBo.getRelation(), judgeResult);
            if (supNumResultMap.containsKey(sku.getSupId())) {
                judgeResult.append(supNumResultMap.get(sku.getSupId()));
            }
            this.assemableEndGroupInfo(i, size, relation, judgeResult);
            skuExpressionMap.put(sku.getSkuId(), judgeResult.toString());
        });
    }

    private void dealBrandAmtJudgeFunc(Map<Long, String> skuExpressionMap, List<IncRuleTriggerSkuBo> skuBos, IncConfRuleDivisorBo divisorBo, List<IncRuleTriggerSkuBo> resultSkuBos, int i, int size, String relation) {
        Map<Long, List<IncRuleTriggerSkuBo>> skuBrandMap = skuBos.stream().collect(Collectors.groupingBy(IncRuleTriggerSkuBo::getBrand));
        HashMap<Long, BigDecimal> skuSupAmtMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, List<IncRuleTriggerSkuBo>> entry : skuBrandMap.entrySet()) {
            skuSupAmtMap.put(entry.getKey(), entry.getValue().stream().map(IncRuleTriggerSkuBo::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        HashMap brandAmtResultMap = new HashMap();
        for (Map.Entry entry : skuSupAmtMap.entrySet()) {
            if (this.isJudge((BigDecimal)entry.getValue(), divisorBo.getJudgment(), divisorBo.getValue())) {
                brandAmtResultMap.put(entry.getKey(), true);
                continue;
            }
            brandAmtResultMap.put(entry.getKey(), false);
        }
        resultSkuBos.forEach(sku -> {
            StringBuffer judgeResult = null;
            judgeResult = skuExpressionMap.containsKey(sku.getSkuId()) ? new StringBuffer((String)skuExpressionMap.get(sku.getSkuId())) : new StringBuffer();
            this.assemableFirstGroupInfo(i, size, relation, judgeResult);
            judgeResult = this.replaceLogicRelation(divisorBo.getRelation(), judgeResult);
            if (brandAmtResultMap.containsKey(sku.getBrand())) {
                judgeResult.append(brandAmtResultMap.get(sku.getSupId()));
            }
            this.assemableEndGroupInfo(i, size, relation, judgeResult);
            skuExpressionMap.put(sku.getSkuId(), judgeResult.toString());
        });
    }

    private void dealBrandNumJudgeFunc(Map<Long, String> skuExpressionMap, List<IncRuleTriggerSkuBo> skuBos, IncConfRuleDivisorBo divisorBo, List<IncRuleTriggerSkuBo> resultSkuBos, int i, int size, String relation) {
        Map<Long, List<IncRuleTriggerSkuBo>> skuBrandMap = skuBos.stream().collect(Collectors.groupingBy(IncRuleTriggerSkuBo::getBrand));
        HashMap<Long, BigDecimal> skuBrandNumMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, List<IncRuleTriggerSkuBo>> entry : skuBrandMap.entrySet()) {
            skuBrandNumMap.put(entry.getKey(), entry.getValue().stream().map(IncRuleTriggerSkuBo::getNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        HashMap brandNumResultMap = new HashMap();
        for (Map.Entry entry : skuBrandNumMap.entrySet()) {
            if (this.isJudge((BigDecimal)entry.getValue(), divisorBo.getJudgment(), divisorBo.getValue())) {
                brandNumResultMap.put(entry.getKey(), true);
                continue;
            }
            brandNumResultMap.put(entry.getKey(), false);
        }
        resultSkuBos.forEach(sku -> {
            StringBuffer judgeResult = null;
            judgeResult = skuExpressionMap.containsKey(sku.getSkuId()) ? new StringBuffer((String)skuExpressionMap.get(sku.getSkuId())) : new StringBuffer();
            this.assemableFirstGroupInfo(i, size, relation, judgeResult);
            judgeResult = this.replaceLogicRelation(divisorBo.getRelation(), judgeResult);
            if (brandNumResultMap.containsKey(sku.getBrand())) {
                judgeResult.append(brandNumResultMap.get(sku.getSupId()));
            }
            this.assemableEndGroupInfo(i, size, relation, judgeResult);
            skuExpressionMap.put(sku.getSkuId(), judgeResult.toString());
        });
    }

    private void dealCatlogContainJudgeFunc(Map<Long, String> skuExpressionMap, List<IncRuleTriggerSkuBo> skuBos, IncConfRuleDivisorBo divisorBo, int i, int size, String relation) {
        skuBos.forEach(sku -> {
            StringBuffer judgeResult = null;
            judgeResult = skuExpressionMap.containsKey(sku.getSkuId()) ? new StringBuffer((String)skuExpressionMap.get(sku.getSkuId())) : new StringBuffer();
            this.assemableFirstGroupInfo(i, size, relation, judgeResult);
            judgeResult = this.replaceLogicRelation(divisorBo.getRelation(), judgeResult);
            String catlogStr = sku.getL1Catolog() + "-" + sku.getL2Catolog() + "-" + sku.getL3Catolog();
            if (catlogStr.contains(divisorBo.getValue())) {
                judgeResult.append(true);
            } else {
                judgeResult.append(false);
            }
            this.assemableEndGroupInfo(i, size, relation, judgeResult);
            skuExpressionMap.put(sku.getSkuId(), judgeResult.toString());
        });
    }

    public boolean executExp(String expression) {
        log.info("\u539f\u59cb\u8868\u8fbe\u5f0f\u4e3a\uff1a{}", (Object)expression);
        expression = expression.replaceAll("\\s+", "");
        expression = expression.replaceAll("true", "true");
        expression = expression.replaceAll("false", "false");
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("js");
        try {
            log.info("\u6267\u884c\u524d\u8868\u8fbe\u5f0f\u4e3a\uff1a{}", (Object)expression);
            Object result = engine.eval(expression);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

