/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.ability.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.merchant.mmc.ability.MmcShopMaintainArticlePageQueryAbilityService;
import com.tydic.merchant.mmc.ability.bo.MmcShopMaintainArticlePageListQueryAbilityReqBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopMaintainArticlePageListQueryAbilityRspBo;
import com.tydic.merchant.mmc.base.MmcRspPageDataBo;
import com.tydic.merchant.mmc.config.MmcPropertiesManager;
import com.tydic.merchant.mmc.constants.MmcConstants;
import com.tydic.merchant.mmc.data.MmcShopMaintainArticleBannerModelDataBo;
import com.tydic.merchant.mmc.enums.MmcPropertiesEnum;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"MMC_GROUP/1.0.0/com.tydic.merchant.mmc.ability.MmcShopMaintainArticlePageQueryAbilityService"})
public class MmcShopMaintainArticlePageQueryAbilityServiceImpl
implements MmcShopMaintainArticlePageQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(MmcShopMaintainArticlePageQueryAbilityServiceImpl.class);
    private static final String UNDERLINE = "_";
    @Autowired
    private MmcPropertiesManager mmcPropertiesManager;

    @PostMapping(value={"queryPageArticle"})
    public MmcShopMaintainArticlePageListQueryAbilityRspBo queryPageArticle(@RequestBody MmcShopMaintainArticlePageListQueryAbilityReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("====\u5e97\u94fa\u7ef4\u62a4-\u6587\u7ae0\u5206\u9875\u67e5\u8be2\uff08CMS\uff09\u5f00\u59cb\uff1a\u5165\u53c2\uff1a{}", (Object)reqBo);
        }
        MmcShopMaintainArticlePageListQueryAbilityRspBo retBo = new MmcShopMaintainArticlePageListQueryAbilityRspBo();
        MmcRspPageDataBo retData = new MmcRspPageDataBo();
        ArrayList<MmcShopMaintainArticleBannerModelDataBo> retRows = new ArrayList<MmcShopMaintainArticleBannerModelDataBo>();
        BeanUtils.copyProperties((Object)reqBo, (Object)retData);
        retBo.setData((Object)retData);
        retData.setRows(retRows);
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("114054");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff0c" + validateStr);
            return retBo;
        }
        List<MmcShopMaintainArticleBannerModelDataBo> dataBos = this.getStaticSource(reqBo);
        if (CollectionUtils.isEmpty(dataBos)) {
            retData.setTotal(Integer.valueOf(0));
            retData.setRecordsTotal(Integer.valueOf(0));
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6210\u529f");
            return retBo;
        }
        retData.setRecordsTotal(Integer.valueOf(dataBos.size()));
        int total = dataBos.size() / reqBo.getPageSize();
        if (dataBos.size() % reqBo.getPageSize() != 0) {
            ++total;
        }
        retData.setTotal(Integer.valueOf(total));
        int pageNo = reqBo.getPageNo();
        int pageSize = reqBo.getPageSize();
        int index = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        for (int i = 0; i < pageSize && i < dataBos.size() - index; ++i) {
            MmcShopMaintainArticleBannerModelDataBo dataBo = dataBos.get(index + i);
            retRows.add(dataBo);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        if (log.isDebugEnabled()) {
            log.debug("====\u5e97\u94fa\u7ef4\u62a4-\u6587\u7ae0\u5206\u9875\u67e5\u8be2\uff08CMS\uff09\u7ed3\u675f\uff1a\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    private List<MmcShopMaintainArticleBannerModelDataBo> getStaticSource(MmcShopMaintainArticlePageListQueryAbilityReqBo reqBo) {
        String resultStr;
        String staticUrl = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_STATIC_SOURCE_URL.getName());
        if (StringUtils.isEmpty((Object)staticUrl)) {
            log.error("CMS\u9759\u6001\u8d44\u6e90\u7684\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1a{}", (Object)MmcPropertiesEnum.CMS_STATIC_SOURCE_URL.getName());
            throw new BusinessException("118005", "CMS\u9759\u6001\u8d44\u6e90\u7684\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1a" + MmcPropertiesEnum.CMS_STATIC_SOURCE_URL.getName());
        }
        String articleCode = MmcConstants.ARTICLE_TYPE.getArticleType((String)reqBo.getArticleType()).getCode();
        StringBuilder columnCodeBuilder = new StringBuilder();
        columnCodeBuilder.append(reqBo.getShopId()).append(UNDERLINE).append(articleCode);
        log.debug("\u5165\u53c2shopId:{}, articleType:{},\u5f97\u5230\u7684\u680f\u76ee\u7f16\u7801\u4e3a:{}", new Object[]{reqBo.getShopId(), reqBo.getArticleType(), columnCodeBuilder.toString()});
        staticUrl = staticUrl.replace("COLUMN_CODE", columnCodeBuilder.toString());
        log.info("\u83b7\u53d6\u9759\u6001\u8d44\u6e90\u7684\u5730\u5740\u4e3a\uff1a{}", (Object)staticUrl);
        try {
            resultStr = HttpUtil.get((String)staticUrl);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6CMS\u9759\u6001\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return null;
        }
        log.info("CMS\u8fd4\u56de\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)resultStr);
        if (resultStr.contains("404 Not Found")) {
            log.error("\u9759\u6001\u5730\u5740\u65e0\u6548\uff1a404 Not Found");
            return null;
        }
        JSONObject resultJson = JSON.parseObject((String)resultStr);
        JSONArray rows = (JSONArray)resultJson.get((Object)"rows");
        List dataBos = JSONObject.parseArray((String)rows.toJSONString(), MmcShopMaintainArticleBannerModelDataBo.class);
        log.debug("\u5c06\u9759\u6001\u8d44\u6e90\u8f6c\u4e3aList\u5f97\u5230\u7684\u7ed3\u679c\uff1a" + dataBos);
        return dataBos;
    }

    private String validateArgs(MmcShopMaintainArticlePageListQueryAbilityReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'shopId'(\u5e97\u94faID)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String articleType = reqBo.getArticleType();
        if (StringUtils.isEmpty((Object)articleType)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'articleType'(\u6587\u7ae0\u7c7b\u578b)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == MmcConstants.ARTICLE_TYPE.getArticleType((String)articleType)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'articleType'\u7684\u53d6\u503c\u8303\u56f4(1.\u8f6e\u64ad\u56fe 2.\u5e7f\u544a\u56fe)";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPageNo())) {
            reqBo.setPageNo(Integer.valueOf(1));
        }
        if (StringUtils.isEmpty((Object)reqBo.getPageSize())) {
            reqBo.setPageSize(Integer.valueOf(5));
        }
        return null;
    }
}

