/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.ability.bo.MmcShopContractSaleBDataBo;
import com.tydic.merchant.mmc.busi.MmcShopContractSaleBBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopContractSaleBBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopContractSaleBusiRspBo;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcShopSaleRelationMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcShopSaleRelationPo;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcShopContractSaleBBusiService")
public class MmcShopContractSaleBBusiServiceImpl
implements MmcShopContractSaleBBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcShopSaleRelationMapper mmcShopSaleRelationMapper;

    public MmcShopContractSaleBusiRspBo saveShopContractSaleB(MmcShopContractSaleBBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u64cd\u4f5cbusi\u670d\u52a1\uff1a" + reqBo);
        MmcShopContractSaleBusiRspBo retBo = new MmcShopContractSaleBusiRspBo();
        String validateStr = this.validateArgs(reqBo.getSaleCatelogList());
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("112005");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String supplierId = ((MmcShopContractSaleBDataBo)reqBo.getSaleCatelogList().get(0)).getSupplierId();
        this.mmcShopSaleRelationMapper.deleteBySupplierId(supplierId);
        for (MmcShopContractSaleBDataBo item : reqBo.getSaleCatelogList()) {
            MmcInfoShopPo reqPo = new MmcInfoShopPo();
            BeanUtils.copyProperties((Object)item, (Object)reqPo);
            MmcInfoShopPo resultPo = this.mmcInfoShopMapper.selectBySupplierId(reqPo);
            if (resultPo == null) break;
            Date dbDate = this.mmcInfoShopMapper.getDbDate();
            MmcShopSaleRelationPo mmcShopSaleRelationPo = new MmcShopSaleRelationPo();
            BeanUtils.copyProperties((Object)item, (Object)mmcShopSaleRelationPo);
            mmcShopSaleRelationPo.setShopId(resultPo.getShopId());
            mmcShopSaleRelationPo.setUpdateTime(dbDate);
            this.mmcShopSaleRelationMapper.insert(mmcShopSaleRelationPo);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(List<MmcShopContractSaleBDataBo> reqBo) {
        if (reqBo.size() == 0) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (MmcShopContractSaleBDataBo item : reqBo) {
            if (StringUtils.isEmpty((Object)item.getSupplierId())) {
                return "supplierId\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (item.getCategoryId() == null) {
                return "categoryId\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (!StringUtils.isEmpty((Object)item.getCategoryName())) continue;
            return "categoryName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

