/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.ability.bo.MmcShopChannelQueryAbilityDataBo;
import com.tydic.merchant.mmc.atom.api.MmcDicMapQueryAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopOpenDetailQueryBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopOpenDetailQueryBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopOpenDetailQueryBusiRspBo;
import com.tydic.merchant.mmc.constants.MmcDictionaryValueConstants;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopChannelMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopChannelPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class MmcShopOpenDetailQueryBusiServiceImpl
implements MmcShopOpenDetailQueryBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcDicMapQueryAtomService mmcDicMapQueryAtomService;
    @Autowired
    private MmcRelShopChannelMapper mmcRelShopChannelMapper;

    public MmcShopOpenDetailQueryBusiRspBo queryShopOpenDetailQuery(MmcShopOpenDetailQueryBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u8be6\u60c5\u67e5\u8be2busi\u670d\u52a1\uff1a" + reqBo);
        MmcShopOpenDetailQueryBusiRspBo retBo = new MmcShopOpenDetailQueryBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("112003");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcInfoShopPo reqPo = new MmcInfoShopPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        List retPo = this.mmcInfoShopMapper.selectShopOpenDetail(reqPo);
        if (retPo == null || retPo.isEmpty()) {
            this.LOGGER.error("\u8c03\u7528mapper\u67e5\u8be2\uff1a\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u8c03\u7528mapper\u67e5\u8be2\uff1a\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            return retBo;
        }
        BeanUtils.copyProperties(retPo.get(0), (Object)retBo);
        if (((MmcInfoShopPo)retPo.get(0)).getTaskState().equals(102)) {
            MmcInfoShopPo reqLogPo = new MmcInfoShopPo();
            reqLogPo.setAuditOrderId(((MmcInfoShopPo)retPo.get(0)).getAuditOrderId());
            List retLogPo = this.mmcInfoShopMapper.selectUocApprovalLog(reqLogPo);
            retBo.setAuditAdvice(((MmcInfoShopPo)retLogPo.get(0)).getAuditAdvice());
            retBo.setDealTime(((MmcInfoShopPo)retLogPo.get(0)).getDealTime());
            retBo.setOperName(((MmcInfoShopPo)retLogPo.get(0)).getOperName());
        }
        this.translate(retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        this.LOGGER.info("\u5e97\u94fa\u8be6\u60c5\u67e5\u8be2busi\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + retBo);
        return retBo;
    }

    private void translate(MmcShopOpenDetailQueryBusiRspBo retBo) {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("SHOP_INFO_CHANNEL");
        typeList.add("SHOP_INFO_STATUS");
        HashMap<String, Map<String, String>> transMap = new HashMap<String, Map<String, String>>(16);
        for (String type : typeList) {
            MmcDicMapQueryAtomReqBo mmcDicMapReqBo = new MmcDicMapQueryAtomReqBo();
            mmcDicMapReqBo.setType(type);
            MmcDicMapQueryAtomRspBo mmcDicMapRetBo = this.mmcDicMapQueryAtomService.qryDicMap(mmcDicMapReqBo);
            if (!"0000".equals(mmcDicMapRetBo.getRespCode())) {
                this.LOGGER.error("\u7ffb\u8bd1TYPE:" + type + "\u5931\u8d25");
                continue;
            }
            Map<String, String> valueMap = mmcDicMapRetBo.getDicMap();
            transMap.put(type, valueMap);
        }
        retBo.setStatusName((String)((Map)transMap.get("SHOP_INFO_STATUS")).get(retBo.getStatus().toString()));
        MmcRelShopChannelPo relShopChannelReqPo = new MmcRelShopChannelPo();
        relShopChannelReqPo.setShopId(retBo.getShopId());
        relShopChannelReqPo.setType(MmcDictionaryValueConstants.REL_SHOP_CHANNEL_TYPE_SELF);
        List relShopChannels = this.mmcRelShopChannelMapper.selectByCondition(relShopChannelReqPo);
        ArrayList<MmcShopChannelQueryAbilityDataBo> channelList = new ArrayList<MmcShopChannelQueryAbilityDataBo>();
        for (MmcRelShopChannelPo relShopChannelPo : relShopChannels) {
            MmcShopChannelQueryAbilityDataBo channelBo = new MmcShopChannelQueryAbilityDataBo();
            channelBo.setChannelId(relShopChannelPo.getChannel());
            channelBo.setChannelName((String)((Map)transMap.get("SHOP_INFO_CHANNEL")).get(relShopChannelPo.getChannel().toString()));
            channelList.add(channelBo);
        }
        retBo.setChannel(channelList);
    }

    private String validateArgs(MmcShopOpenDetailQueryBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

