/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.ability.bo.MmcShopChannelQueryAbilityDataBo;
import com.tydic.merchant.mmc.atom.api.MmcDicMapQueryAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopRecommendPushQueryBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopListQueryBusiDataBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopRecommendPushQueryBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopRecommendPushQueryBusiRspBo;
import com.tydic.merchant.mmc.constants.MmcDictionaryValueConstants;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopChannelMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopListQueryPo;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopChannelPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcShopRecommendPushQueryBusiService")
public class MmcShopRecommendPushQueryBusiServiceImpl
implements MmcShopRecommendPushQueryBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcRelShopChannelMapper mmcRelShopChannelMapper;
    @Autowired
    private MmcDicMapQueryAtomService mmcDicMapQueryAtomService;

    public MmcShopRecommendPushQueryBusiRspBo shopPushQuery(MmcShopRecommendPushQueryBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u63a8\u8350\u5217\u8868\u67e5\u8be2busi\u670d\u52a1\uff1a" + reqBo);
        MmcShopRecommendPushQueryBusiRspBo retBo = new MmcShopRecommendPushQueryBusiRspBo();
        ArrayList<MmcShopListQueryBusiDataBo> data = new ArrayList<MmcShopListQueryBusiDataBo>();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("112020");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcInfoShopListQueryPo shopReqPo = new MmcInfoShopListQueryPo();
        shopReqPo.setChannel(Integer.valueOf(Integer.parseInt(reqBo.getChannel())));
        shopReqPo.setStatus(Integer.valueOf(Integer.parseInt("4")));
        shopReqPo.setType(MmcDictionaryValueConstants.REL_SHOP_CHANNEL_TYPE_SELF);
        List shopList = this.mmcInfoShopMapper.selectByCondition(shopReqPo);
        if (!CollectionUtils.isEmpty((Collection)shopList)) {
            this.translate(data, shopList);
        }
        retBo.setData(data);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void translate(List<MmcShopListQueryBusiDataBo> retRows, List<MmcInfoShopPo> shopList) {
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        for (MmcInfoShopPo shopPo : shopList) {
            MmcShopListQueryBusiDataBo busiDataBo = new MmcShopListQueryBusiDataBo();
            MmcRelShopChannelPo relPo = new MmcRelShopChannelPo();
            relPo.setShopId(shopPo.getShopId());
            relPo.setType(MmcDictionaryValueConstants.REL_SHOP_CHANNEL_TYPE_SELF);
            List relRspPos = this.mmcRelShopChannelMapper.selectByCondition(relPo);
            ArrayList<MmcShopChannelQueryAbilityDataBo> channelList = new ArrayList<MmcShopChannelQueryAbilityDataBo>();
            if (!CollectionUtils.isEmpty((Collection)relRspPos)) {
                for (MmcRelShopChannelPo relShopChannelPo : relRspPos) {
                    MmcShopChannelQueryAbilityDataBo channelBo = new MmcShopChannelQueryAbilityDataBo();
                    channelBo.setChannelId(relShopChannelPo.getChannel());
                    channelBo.setChannelName(dicMap.get("SHOP_INFO_CHANNEL").get(relShopChannelPo.getChannel().toString()));
                    channelList.add(channelBo);
                }
            }
            BeanUtils.copyProperties((Object)shopPo, (Object)busiDataBo);
            busiDataBo.setStatus(shopPo.getStatus());
            busiDataBo.setStatusName(dicMap.get("SHOP_INFO_STATUS").get(busiDataBo.getStatus().toString()));
            busiDataBo.setChannel(channelList);
            retRows.add(busiDataBo);
        }
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> typeMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("SHOP_INFO_STATUS");
        typeList.add("SHOP_INFO_CHANNEL");
        MmcDicMapQueryAtomReqBo dicMapReqBo = new MmcDicMapQueryAtomReqBo();
        for (String type : typeList) {
            dicMapReqBo.setType(type);
            MmcDicMapQueryAtomRspBo dicMapRspBo = this.mmcDicMapQueryAtomService.qryDicMap(dicMapReqBo);
            if (dicMapRspBo.getDicMap() == null) continue;
            typeMap.put(type, dicMapRspBo.getDicMap());
        }
        return typeMap;
    }

    private String validateArgs(MmcShopRecommendPushQueryBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getChannel())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'channel'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

