/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.ability.bo.MmcFitmentShopPageSaveAbilityReqBo;
import com.tydic.merchant.mmc.ability.bo.MmcFitmentShopPageSaveAbilityReqPageComponentDataBo;
import com.tydic.merchant.mmc.ability.bo.MmcFitmentShopPageSaveAbilityReqPageComponentPropertyDataBo;
import com.tydic.merchant.mmc.atom.bo.MmcFitmentSysComponentAtomQueryComponentRspBo;
import com.tydic.merchant.mmc.atom.impl.MmcFitmentSysComponentAtomService;
import com.tydic.merchant.mmc.busi.MmcFitmentShopPageSaveBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentShopPageSaveBusiRspBo;
import com.tydic.merchant.mmc.config.MmcSequence;
import com.tydic.merchant.mmc.constants.MmcFitmentDicValueConstants;
import com.tydic.merchant.mmc.dao.MmcFitmentPageMapper;
import com.tydic.merchant.mmc.dao.MmcFitmentRelPageComponentMapper;
import com.tydic.merchant.mmc.dao.MmcFitmentRelPageComponentPropertiesMapper;
import com.tydic.merchant.mmc.dao.MmcFitmentShopSelfComponentMapper;
import com.tydic.merchant.mmc.dao.MmcInfoMerchantMapper;
import com.tydic.merchant.mmc.dao.po.MmcFitmentPagePo;
import com.tydic.merchant.mmc.dao.po.MmcFitmentRelPageComponentPo;
import com.tydic.merchant.mmc.dao.po.MmcFitmentRelPageComponentPropertiesPo;
import com.tydic.merchant.mmc.dao.po.MmcFitmentShopSelfComponentPo;
import com.tydic.merchant.mmc.exception.MmcBusinessException;
import com.tydic.merchant.mmc.utils.MmcRspBoUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MmcFitmentShopPageSaveBusiServiceImpl
implements MmcFitmentShopPageSaveBusiService {
    @Autowired
    private MmcFitmentPageMapper mmcFitmentPageMapper;
    @Autowired
    private MmcFitmentRelPageComponentMapper mmcFitmentRelPageComponentMapper;
    @Autowired
    private MmcFitmentRelPageComponentPropertiesMapper mmcFitmentRelPageComponentPropertiesMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private MmcInfoMerchantMapper mmcInfoMerchantMapper;
    @Autowired
    private MmcFitmentSysComponentAtomService mmcFitmentSysComponentAtomService;
    @Autowired
    private MmcFitmentShopSelfComponentMapper mmcFitmentShopSelfComponentMapper;

    public MmcFitmentShopPageSaveBusiRspBo savePage(MmcFitmentShopPageSaveAbilityReqBo reqBo) {
        List components = reqBo.getComponents();
        Long shopId = reqBo.getShopId();
        Map<Long, Integer> componentSelfMap = this.validateComponents(components, shopId);
        Date now = this.mmcInfoMerchantMapper.getDbDate().getDate();
        long pageId = MmcSequence.nextId();
        MmcFitmentPagePo insertPagePo = new MmcFitmentPagePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)insertPagePo);
        insertPagePo.setPageId(Long.valueOf(pageId));
        insertPagePo.setStatusFlag(MmcFitmentDicValueConstants.MMC_FITMENT_PAGE_STATUS_FLAG_USABLE);
        insertPagePo.setCreateTime(now);
        insertPagePo.setPutaway(MmcFitmentDicValueConstants.MMC_FITMENT_PAGE_PUTAWAY_NO);
        insertPagePo.setMainPage(MmcFitmentDicValueConstants.MMC_FITMENT_PAGE_MAIN_PAGE_NOT);
        int insertPageRet = this.mmcFitmentPageMapper.insert(insertPagePo);
        if (insertPageRet < 1) {
            throw new MmcBusinessException("116010", "\u63d2\u5165\u5e97\u94fa\u9875\u9762\u5931\u8d25\uff1a\u63d2\u5165\u8fd4\u56de\u5c0f\u4e8e1");
        }
        this.addComponentAndProperties(components, shopId, pageId, 0L, componentSelfMap);
        MmcFitmentShopPageSaveBusiRspBo mmcFitmentShopPageSaveBusiRspBo = MmcRspBoUtil.genSuccessBo(MmcFitmentShopPageSaveBusiRspBo.class);
        mmcFitmentShopPageSaveBusiRspBo.setPageId(Long.valueOf(pageId));
        return mmcFitmentShopPageSaveBusiRspBo;
    }

    public Map<Long, Integer> validateComponents(List<MmcFitmentShopPageSaveAbilityReqPageComponentDataBo> components, Long shopId) {
        HashMap<Long, Integer> componentSelfMap = new HashMap<Long, Integer>(16);
        if (!CollectionUtils.isEmpty(components)) {
            List<Long> distinctCodes = this.getDistinctCode(components);
            MmcFitmentSysComponentAtomQueryComponentRspBo sysComponent = this.mmcFitmentSysComponentAtomService.queryComponent();
            Set<Long> selfComps = this.querySelfComps(distinctCodes, shopId);
            for (Long componentCode : distinctCodes) {
                if (!sysComponent.getData().keySet().contains(componentCode) && !selfComps.contains(componentCode)) {
                    throw new MmcBusinessException("116010", "\u7ec4\u4ef6\u7f16\u7801(" + componentCode + ")\u5373\u4e0d\u662f\u7cfb\u7edf\u7ec4\u4ef6\u4e5f\u4e0d\u662f\u81ea\u5b9a\u4e49\u7ec4\u4ef6");
                }
                if (sysComponent.getData().keySet().contains(componentCode)) {
                    componentSelfMap.put(componentCode, Integer.valueOf("0"));
                    continue;
                }
                componentSelfMap.put(componentCode, Integer.valueOf("1"));
            }
        }
        return componentSelfMap;
    }

    private List<Long> getDistinctCode(List<MmcFitmentShopPageSaveAbilityReqPageComponentDataBo> components) {
        HashSet<Long> componentIds = new HashSet<Long>();
        for (MmcFitmentShopPageSaveAbilityReqPageComponentDataBo component : components) {
            componentIds.add(component.getComponentCode());
            List children = component.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            for (MmcFitmentShopPageSaveAbilityReqPageComponentDataBo child : children) {
                componentIds.add(child.getComponentCode());
            }
        }
        return new ArrayList<Long>(componentIds);
    }

    private Set<Long> querySelfComps(List<Long> components, Long shopId) {
        List pos = this.mmcFitmentShopSelfComponentMapper.selectBySelfComponentIds(components, shopId);
        HashSet<Long> retSet = new HashSet<Long>(16);
        if (!CollectionUtils.isEmpty((Collection)pos)) {
            for (MmcFitmentShopSelfComponentPo po : pos) {
                retSet.add(po.getComponentId());
            }
        }
        return retSet;
    }

    public void addComponentAndProperties(List<MmcFitmentShopPageSaveAbilityReqPageComponentDataBo> components, Long shopId, Long pageId, Long parentRelId, Map<Long, Integer> selfCompMap) {
        int orderNo = 0;
        for (MmcFitmentShopPageSaveAbilityReqPageComponentDataBo componentDataBo : components) {
            MmcFitmentRelPageComponentPo insertComponentPo = new MmcFitmentRelPageComponentPo();
            Long componentRelId = MmcSequence.nextId();
            insertComponentPo.setRelId(componentRelId);
            insertComponentPo.setParentId(parentRelId);
            insertComponentPo.setShopId(shopId);
            insertComponentPo.setPageId(pageId);
            insertComponentPo.setStatusFlag(MmcFitmentDicValueConstants.MMC_FITMENT_REL_PAGE_COMPONENT_STATUS_FLAG_VALID);
            insertComponentPo.setSortNo(Integer.valueOf(orderNo));
            insertComponentPo.setComponentCode(componentDataBo.getComponentCode());
            insertComponentPo.setSelfTemplate(selfCompMap.get(componentDataBo.getComponentCode()));
            int insertRelRet = this.mmcFitmentRelPageComponentMapper.insert(insertComponentPo);
            if (insertRelRet < 1) {
                throw new MmcBusinessException("116010", "\u63d2\u5165\u5e97\u94fa\u9875\u9762-\u7ec4\u4ef6\u5173\u7cfb\u8868\u5931\u8d25\uff1a\u63d2\u5165\u8fd4\u56de\u5c0f\u4e8e1");
            }
            List properties = componentDataBo.getProperties();
            int propertyOrder = 0;
            for (MmcFitmentShopPageSaveAbilityReqPageComponentPropertyDataBo propertyBo : properties) {
                Long propertyId = MmcSequence.nextId();
                MmcFitmentRelPageComponentPropertiesPo insertPropertyPo = new MmcFitmentRelPageComponentPropertiesPo();
                insertPropertyPo.setPropertyId(propertyId);
                insertPropertyPo.setShopId(shopId);
                insertPropertyPo.setPageId(pageId);
                insertPropertyPo.setRelId(componentRelId);
                insertPropertyPo.setSortNo(Integer.valueOf(propertyOrder));
                insertPropertyPo.setSortNo(Integer.valueOf(0));
                insertPropertyPo.setComponentCode(componentDataBo.getComponentCode());
                insertPropertyPo.setPropertyCode(propertyBo.getPropertyCode());
                insertPropertyPo.setPropertyValue(propertyBo.getPropertyValue());
                int insertPropertyRet = this.mmcFitmentRelPageComponentPropertiesMapper.insert(insertPropertyPo);
                if (insertPropertyRet < 1) {
                    throw new MmcBusinessException("116010", "\u63d2\u5165\u5e97\u94fa\u9875\u9762-\u7ec4\u4ef6-\u5c5e\u6027\u8868\u5931\u8d25\uff1a\u63d2\u5165\u8fd4\u56de\u5c0f\u4e8e1");
                }
                ++propertyOrder;
            }
            ++orderNo;
            List children = componentDataBo.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            this.addComponentAndProperties(children, shopId, pageId, componentRelId, selfCompMap);
        }
    }
}

