/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.merchant.mmc.ability.bo.MmcShopChannelQueryAbilityDataBo;
import com.tydic.merchant.mmc.atom.api.MmcDicMapQueryAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomRspBo;
import com.tydic.merchant.mmc.base.MmcRspPageBo;
import com.tydic.merchant.mmc.base.MmcRspPageDataBo;
import com.tydic.merchant.mmc.busi.MmcShopHotDegreeListQueryBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopApproveListQueryBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopHotDegreeListQueryBusiDataBo;
import com.tydic.merchant.mmc.constants.MmcDictionaryValueConstants;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopChannelMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopHotDegreePo;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopChannelPo;
import com.tydic.merchant.mmc.dao.po.MmcShopApproveListQueryPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcShopHotDegreeListQueryBusiService")
public class MmcShopHotDegreeListQueryBusiServiceImpl
implements MmcShopHotDegreeListQueryBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcRelShopChannelMapper mmcRelShopChannelMapper;
    @Autowired
    private MmcDicMapQueryAtomService mmcDicMapQueryAtomService;

    public MmcRspPageBo<MmcRspPageDataBo<MmcShopHotDegreeListQueryBusiDataBo>> queryHotDegreeList(MmcShopApproveListQueryBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u63a8\u5e7f-\u70ed\u5ea6\u5217\u8868\u67e5\u8be2\u670d\u52a1\uff1a" + reqBo);
        MmcRspPageBo retBo = new MmcRspPageBo();
        MmcRspPageDataBo retData = new MmcRspPageDataBo();
        ArrayList<MmcShopHotDegreeListQueryBusiDataBo> retRows = new ArrayList<MmcShopHotDegreeListQueryBusiDataBo>();
        Page<MmcInfoShopPo> page = this.getPage(reqBo);
        MmcShopApproveListQueryPo reqPo = new MmcShopApproveListQueryPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        this.LOGGER.info("\u5e97\u94fa\u63a8\u5e7f-\u70ed\u5ea6\u5217\u8868\u67e5\u8be2\u670d\u52a1Po\uff1a" + reqPo);
        List retPos = this.mmcInfoShopMapper.selectHotDegreeList(reqPo, page);
        this.translation(retPos, retRows);
        retData.setRows(retRows);
        retData.setPageNo(Integer.valueOf(page.getPageNo()));
        retData.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        retData.setTotal(Integer.valueOf(page.getTotalPages()));
        retBo.setData((Object)retData);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void translation(List<MmcInfoShopHotDegreePo> retPos, List<MmcShopHotDegreeListQueryBusiDataBo> retRows) {
        Map<String, Map<String, String>> dicMap = this.queryTranslateMap();
        for (MmcInfoShopHotDegreePo po : retPos) {
            MmcShopHotDegreeListQueryBusiDataBo busiDataBo = new MmcShopHotDegreeListQueryBusiDataBo();
            MmcRelShopChannelPo relShopChannelReqPo = new MmcRelShopChannelPo();
            relShopChannelReqPo.setShopId(po.getShopId());
            relShopChannelReqPo.setType(MmcDictionaryValueConstants.REL_SHOP_CHANNEL_TYPE_SELF);
            List relShopChannels = this.mmcRelShopChannelMapper.selectByCondition(relShopChannelReqPo);
            ArrayList<MmcShopChannelQueryAbilityDataBo> channelList = new ArrayList<MmcShopChannelQueryAbilityDataBo>();
            if (!CollectionUtils.isEmpty((Collection)relShopChannels)) {
                for (MmcRelShopChannelPo relShopChannelPo : relShopChannels) {
                    MmcShopChannelQueryAbilityDataBo channelBo = new MmcShopChannelQueryAbilityDataBo();
                    channelBo.setChannelId(relShopChannelPo.getChannel());
                    channelBo.setChannelName(dicMap.get("SHOP_INFO_CHANNEL").get(relShopChannelPo.getChannel().toString()));
                    channelList.add(channelBo);
                }
            }
            BeanUtils.copyProperties((Object)po, (Object)busiDataBo);
            busiDataBo.setStatus(po.getStatus());
            busiDataBo.setStatusName(dicMap.get("SHOP_INFO_STATUS").get(busiDataBo.getStatus().toString()));
            busiDataBo.setChannel(channelList);
            retRows.add(busiDataBo);
        }
    }

    private Page<MmcInfoShopPo> getPage(MmcShopApproveListQueryBusiReqBo reqBo) {
        Page page;
        if (reqBo.getPageNo() != 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (reqBo.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (reqBo.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }

    private Map<String, Map<String, String>> queryTranslateMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("SHOP_INFO_CHANNEL");
        typeList.add("SHOP_INFO_STATUS");
        for (String type : typeList) {
            MmcDicMapQueryAtomReqBo dicMapReqBo = new MmcDicMapQueryAtomReqBo();
            dicMapReqBo.setType(type);
            MmcDicMapQueryAtomRspBo dicMapRetBo = this.mmcDicMapQueryAtomService.qryDicMap(dicMapReqBo);
            if (!"0000".equals(dicMapRetBo.getRespCode())) {
                this.LOGGER.error("\u67e5\u8be2type= '" + type + "'\u7684\u503c\u5931\u8d25");
                continue;
            }
            Map<String, String> valueMap = dicMapRetBo.getDicMap();
            dicMap.put(type, valueMap);
        }
        return dicMap;
    }

    private String validateArgs(MmcShopApproveListQueryBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getQueryType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'queryType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getUserId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'userId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPosition())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'position'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

