/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.ability.bo.MmcShopChannelQueryAbilityDataBo;
import com.tydic.merchant.mmc.atom.api.MmcDicMapQueryAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopOpenApproveListExportBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopApproveListExportBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopApproveListExportBusiRspBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopListQueryBusiDataBo;
import com.tydic.merchant.mmc.constants.MmcDictionaryValueConstants;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopChannelMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopChannelPo;
import com.tydic.merchant.mmc.dao.po.MmcShopApproveListQueryPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcShopOpenApproveListExportBusiService")
public class MmcShopOpenApproveListExportBusiServiceImpl
implements MmcShopOpenApproveListExportBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcRelShopChannelMapper mmcRelShopChannelMapper;
    @Autowired
    private MmcDicMapQueryAtomService mmcDicMapQueryAtomService;

    public MmcShopApproveListExportBusiRspBo exportList(MmcShopApproveListExportBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u5f00\u5e97\u5ba1\u6279\u5217\u8868\u5bfc\u51fabusi\u670d\u52a1 \u5b9e\u73b0\u7c7b");
        MmcShopApproveListExportBusiRspBo retBo = new MmcShopApproveListExportBusiRspBo();
        ArrayList<MmcShopListQueryBusiDataBo> data = new ArrayList<MmcShopListQueryBusiDataBo>();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25:" + validateStr);
            retBo.setRespCode("112011");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcShopApproveListQueryPo reqPo = new MmcShopApproveListQueryPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        reqPo.setStatusList(statusList);
        reqPo.setType(MmcDictionaryValueConstants.REL_SHOP_CHANNEL_TYPE_SELF);
        if ("3".equals(reqBo.getQueryType().toString())) {
            statusList.add(Integer.parseInt("3"));
            statusList.add(Integer.parseInt("4"));
            reqPo.setTaskStatus(Integer.valueOf(Integer.parseInt("102")));
        } else {
            statusList.add(Integer.parseInt("2"));
            reqPo.setTaskStatus(Integer.valueOf(Integer.parseInt("100")));
        }
        List retPos = this.mmcInfoShopMapper.selectApproveList(reqPo);
        if (CollectionUtils.isEmpty((Collection)retPos)) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u76f8\u5339\u914d\u7684\u6570\u636e");
            retBo.setRespCode("112011");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u76f8\u5339\u914d\u7684\u6570\u636e");
            return retBo;
        }
        Map<String, Map<String, String>> dicMap = this.queryTranslateMap();
        for (MmcInfoShopPo po : retPos) {
            this.assignData(po, data, dicMap);
        }
        retBo.setData(data);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void assignData(MmcInfoShopPo po, List<MmcShopListQueryBusiDataBo> data, Map<String, Map<String, String>> dicMap) {
        MmcShopListQueryBusiDataBo busiDataBo = new MmcShopListQueryBusiDataBo();
        MmcRelShopChannelPo relShopChannelReqPo = new MmcRelShopChannelPo();
        relShopChannelReqPo.setShopId(po.getShopId());
        relShopChannelReqPo.setType(MmcDictionaryValueConstants.REL_SHOP_CHANNEL_TYPE_SELF);
        List relShopChannels = this.mmcRelShopChannelMapper.selectByCondition(relShopChannelReqPo);
        ArrayList<MmcShopChannelQueryAbilityDataBo> channelList = new ArrayList<MmcShopChannelQueryAbilityDataBo>();
        if (!CollectionUtils.isEmpty((Collection)relShopChannels)) {
            for (MmcRelShopChannelPo relShopChannelPo : relShopChannels) {
                MmcShopChannelQueryAbilityDataBo channelBo = new MmcShopChannelQueryAbilityDataBo();
                channelBo.setChannelId(relShopChannelPo.getChannel());
                channelBo.setChannelName(dicMap.get("SHOP_INFO_CHANNEL").get(relShopChannelPo.getChannel().toString()));
                channelList.add(channelBo);
            }
        }
        BeanUtils.copyProperties((Object)po, (Object)busiDataBo);
        busiDataBo.setStatus(po.getStatus());
        busiDataBo.setStatusName(dicMap.get("SHOP_INFO_STATUS").get(busiDataBo.getStatus().toString()));
        busiDataBo.setChannel(channelList);
        data.add(busiDataBo);
    }

    private Map<String, Map<String, String>> queryTranslateMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("SHOP_INFO_CHANNEL");
        typeList.add("SHOP_INFO_STATUS");
        for (String type : typeList) {
            MmcDicMapQueryAtomReqBo dicMapReqBo = new MmcDicMapQueryAtomReqBo();
            dicMapReqBo.setType(type);
            MmcDicMapQueryAtomRspBo dicMapRetBo = this.mmcDicMapQueryAtomService.qryDicMap(dicMapReqBo);
            if (!"0000".equals(dicMapRetBo.getRespCode())) {
                this.LOGGER.error("\u67e5\u8be2type= '" + type + "'\u7684\u503c\u5931\u8d25");
                continue;
            }
            Map<String, String> valueMap = dicMapRetBo.getDicMap();
            dicMap.put(type, valueMap);
        }
        return dicMap;
    }

    private String validateArgs(MmcShopApproveListExportBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getQueryType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'queryType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

