/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.comb.impl;

import com.tydic.merchant.mmc.busi.MmcShopApproveBusiService;
import com.tydic.merchant.mmc.busi.MmcShopSetingApproveBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopApproveBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopApproveBusiRspBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopSetingApproveBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopSetingApproveBusiRspBo;
import com.tydic.merchant.mmc.comb.MmcShopApproveCombService;
import com.tydic.merchant.mmc.comb.bo.MmcShopApproveCombReqBo;
import com.tydic.merchant.mmc.comb.bo.MmcShopApproveCombRspBo;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopSettingMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopSettingPo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcShopApproveCombService")
public class MmcShopApproveCombServiceImpl
implements MmcShopApproveCombService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcShopApproveBusiService mmcShopApproveBusiService;
    @Autowired
    private MmcShopSetingApproveBusiService mmcShopSetingApproveBusiService;
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcRelShopSettingMapper mmcRelShopSettingMapper;

    public MmcShopApproveCombRspBo approveShop(MmcShopApproveCombReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u5ba1\u6279comb\u670d\u52a1\uff1a" + reqBo);
        MmcShopApproveCombRspBo retBo = new MmcShopApproveCombRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("113009");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        boolean validateShopInfoFlag = this.validateShopInfo(reqBo, retBo);
        if (!validateShopInfoFlag) {
            return retBo;
        }
        if ("1".equals(reqBo.getOpType())) {
            MmcShopApproveBusiReqBo shopBusiReqBo = new MmcShopApproveBusiReqBo();
            BeanUtils.copyProperties((Object)reqBo, (Object)shopBusiReqBo);
            MmcShopApproveBusiRspBo shopBusiRspBo = this.mmcShopApproveBusiService.updateShopStatus(shopBusiReqBo);
            if (!"0000".equals(shopBusiRspBo.getRespCode())) {
                this.LOGGER.error("\u8c03\u7528\u5e97\u94fa\u5ba1\u6279busi\u670d\u52a1\u5931\u8d25\uff1a" + shopBusiRspBo.getRespDesc());
                retBo.setRespCode("113009");
                retBo.setRespDesc(shopBusiRspBo.getRespDesc());
                return retBo;
            }
        } else {
            MmcShopSetingApproveBusiReqBo shopSetingBusiReqBo = new MmcShopSetingApproveBusiReqBo();
            BeanUtils.copyProperties((Object)reqBo, (Object)shopSetingBusiReqBo);
            MmcShopSetingApproveBusiRspBo shopSetingBusiRspBo = this.mmcShopSetingApproveBusiService.updateShopStatus(shopSetingBusiReqBo);
            if (!"0000".equals(shopSetingBusiRspBo.getRespCode())) {
                this.LOGGER.error("\u8c03\u7528\u5e97\u94fa\u8bbe\u7f6e\u4e2d\u5ba1\u6279busi\u670d\u52a1\u5931\u8d25\uff1a" + shopSetingBusiRspBo.getRespDesc());
                retBo.setRespCode("113009");
                retBo.setRespDesc(shopSetingBusiRspBo.getRespDesc());
                return retBo;
            }
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private boolean validateShopInfo(MmcShopApproveCombReqBo reqBo, MmcShopApproveCombRspBo retBo) {
        boolean shopInfoFlag = true;
        if ("1".equals(reqBo.getOpType())) {
            for (Long shopId : reqBo.getApproveIds()) {
                MmcInfoShopPo qryRspPo = this.mmcInfoShopMapper.selectByPrimaryKey(shopId);
                if (qryRspPo == null) {
                    shopInfoFlag = false;
                    retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5e97\u94fa: \uff08" + shopId + ")\u76f8\u5173\u7684\u4fe1\u606f");
                    retBo.setRespCode("113009");
                } else {
                    if ("2".equals(qryRspPo.getStatus() + "")) continue;
                    shopInfoFlag = false;
                    retBo.setRespDesc("\u5e97\u94fa\uff1a\uff08" + shopId + "\uff09\u72b6\u6001\u4e0d\u4e3a\u5f85\u5ba1\u6279");
                    retBo.setRespCode("113009");
                }
                break;
            }
        } else {
            MmcRelShopSettingPo qryShopSettingReqPo = new MmcRelShopSettingPo();
            for (Long shopId : reqBo.getApproveIds()) {
                qryShopSettingReqPo.setShopId(shopId);
                qryShopSettingReqPo.setStatus(Integer.valueOf(Integer.parseInt("2")));
                List shopSettingPos = this.mmcRelShopSettingMapper.selectByCondition(qryShopSettingReqPo);
                if (CollectionUtils.isEmpty((Collection)shopSettingPos)) {
                    shopInfoFlag = false;
                    retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5e97\u94fa: \uff08" + shopId + ")\u8bbe\u7f6e\u4e2d\u8d44\u6599\u7684\u76f8\u5173\u4fe1\u606f");
                    retBo.setRespCode("113009");
                    break;
                }
                if (!"2".equals(((MmcRelShopSettingPo)shopSettingPos.get(0)).getStatus() + "")) {
                    shopInfoFlag = false;
                    retBo.setRespDesc("\u5e97\u94fa\uff1a\uff08" + shopId + "\uff09\u7684\u8bbe\u7f6e\u4e2d\u8d44\u6599\u72b6\u6001\u4e0d\u4e3a\u5f85\u5ba1\u6279");
                    retBo.setRespCode("113009");
                    break;
                }
                shopSettingPos.clear();
            }
        }
        return shopInfoFlag;
    }

    private String validateArgs(MmcShopApproveCombReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDesc())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'desc'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getApproveAction())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'approveAction'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getApproveIds())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'approveIds'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOpType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'opType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getUserId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'userId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

