/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mmc.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.mmc.atom.api.MmcDealApprovalAtomService;
import com.tydic.mmc.atom.bo.MmcDealApprovalAtomReqBO;
import com.tydic.mmc.atom.bo.MmcDealApprovalAtomRspBO;
import com.tydic.mmc.busi.api.MmcOperShopFrozenAuditBusiService;
import com.tydic.mmc.busi.bo.MmcOperShopFrozenAuditBusiReqBO;
import com.tydic.mmc.busi.bo.MmcOperShopFrozenAuditBusiRspBO;
import com.tydic.mmc.constants.MmcConstant;
import com.tydic.mmc.dao.MmcAuditRecordMapper;
import com.tydic.mmc.dao.MmcShopMapper;
import com.tydic.mmc.po.MmcAuditRecordPo;
import com.tydic.mmc.po.MmcShopPo;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MmcOperShopFrozenAuditBusiServiceImpl
implements MmcOperShopFrozenAuditBusiService {
    @Autowired
    private MmcDealApprovalAtomService mmcDealApprovalAtomService;
    @Autowired
    private MmcShopMapper mmcShopMapper;
    @Autowired
    private MmcAuditRecordMapper mmcAuditRecordMapper;

    @Override
    public MmcOperShopFrozenAuditBusiRspBO operShopFrozenAudit(MmcOperShopFrozenAuditBusiReqBO reqBO) {
        MmcOperShopFrozenAuditBusiRspBO rspBO = new MmcOperShopFrozenAuditBusiRspBO();
        MmcAuditRecordPo auditRecordInfoPo = this.queryOriginalAuditRecord(reqBO.getShopId(), reqBO.getStepId());
        if (MmcConstant.AuditResult.AUDIT_RESULT_YES.equals(reqBO.getAuditResult())) {
            auditRecordInfoPo.setAuditStatus("2");
        } else {
            auditRecordInfoPo.setAuditStatus("3");
        }
        auditRecordInfoPo.setAuditRemark(reqBO.getAuditAdvice());
        this.updateAuditRecord(auditRecordInfoPo);
        MmcShopPo shopInfoPo = this.queryOriginalShopInfo(reqBO.getShopId());
        if (MmcConstant.AuditResult.AUDIT_RESULT_YES.equals(reqBO.getAuditResult())) {
            shopInfoPo.setStatus("5");
        } else {
            shopInfoPo.setStatus("3");
        }
        this.updateShopInfo(shopInfoPo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private MmcDealApprovalAtomRspBO approvalShopCreate(MmcOperShopFrozenAuditBusiReqBO reqBO) {
        MmcDealApprovalAtomReqBO mmcDealApprovalAtomReqBO = new MmcDealApprovalAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)mmcDealApprovalAtomReqBO);
        mmcDealApprovalAtomReqBO.setObjType(Integer.valueOf("3"));
        MmcDealApprovalAtomRspBO mmcDealApprovalAtomRspBO = this.mmcDealApprovalAtomService.dealApproval(mmcDealApprovalAtomReqBO);
        if (!"0000".equals(mmcDealApprovalAtomRspBO.getRespCode())) {
            throw new ZTBusinessException(mmcDealApprovalAtomRspBO.getRespDesc());
        }
        return mmcDealApprovalAtomRspBO;
    }

    private MmcShopPo queryOriginalShopInfo(Long shopId) {
        MmcShopPo originalShopPo = this.mmcShopMapper.selectByPrimaryKey(shopId);
        if (null != originalShopPo) {
            return originalShopPo;
        }
        throw new ZTBusinessException("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
    }

    private void updateShopInfo(MmcShopPo updateShopPo) {
        int updateShopInfoResult = this.mmcShopMapper.updateByPrimaryKeySelective(updateShopPo);
        if (1 != updateShopInfoResult) {
            throw new ZTBusinessException("\u5e97\u94fa\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
    }

    private MmcAuditRecordPo queryOriginalAuditRecord(Long shopId, String stepId) {
        MmcAuditRecordPo queryAuditRecordPo = new MmcAuditRecordPo();
        queryAuditRecordPo.setShopId(shopId);
        queryAuditRecordPo.setAuditType("3");
        List<MmcAuditRecordPo> mmcAuditRecordPos = this.mmcAuditRecordMapper.selectByCondition(queryAuditRecordPo);
        if (!CollectionUtils.isEmpty(mmcAuditRecordPos) && mmcAuditRecordPos.size() == 1) {
            return mmcAuditRecordPos.get(0);
        }
        if (!CollectionUtils.isEmpty(mmcAuditRecordPos) && mmcAuditRecordPos.size() > 1) {
            throw new ZTBusinessException("\u5b58\u5728\u591a\u6761\u5e97\u94fa\u51bb\u7ed3\u5ba1\u6279\u8bb0\u5f55");
        }
        throw new ZTBusinessException("\u5e97\u94fa\u51bb\u7ed3\u5ba1\u6279\u8bb0\u5f55\u4e0d\u5b58\u5728");
    }

    private void updateAuditRecord(MmcAuditRecordPo updateAuditRecordPo) {
        this.mmcAuditRecordMapper.updateByPrimaryKeySelective(updateAuditRecordPo);
    }
}

