package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/14 21:55
 */
@Data
public class UocCreateOrderServiceReqCommodityBo implements Serializable {

    private static final long serialVersionUID = 6454961344338211931L;

    @DocField(value = "单品ID",required = true)
    private String skuId;

    @DocField(value = "单品名称",required = true)
    private String skuName;

    @DocField(value = "商品id",required = true)
    private String commodityId;

    @DocField(value = "商品名称",required = true)
    private String commodityName;

    @DocField(value = "商品类型ID")
    private String commodityTypeId;

    @DocField(value = "商品类型名称")
    private String commodityTypeName;

    @DocField(value = "供应商id",required = true)
    private String supId;

    @DocField(value = "供应商编码")
    private String supNo;

    @DocField(value = "供应商名称",required = true)
    private String supName;

    @DocField(value = "供应商联系人")
    private String supRelaName;

    @DocField(value = "供应商联系电话")
    private String supRelaMobile;

    @DocField(value = "店铺ID",required = true)
    private String supplierShopId;

    @DocField(value = "店铺名称")
    private String supplierShopName;

    @DocField(value = "采购单价",required = true)
    private BigDecimal purchasePrice;

    @DocField(value = "销售单价",required = true)
    private BigDecimal salePrice;

    @DocField(value = "采购数量",required = true)
    private BigDecimal purchaseCount;

    @DocField(value = "商品来源，区分电商、协议、无协议", required = true,valArg = "商品来源")
    private Integer skuSource;

    @DocField(value = "运费")
    private BigDecimal transFee;

    @DocField(value = "计量单位",required = true)
    private String unitName;

    @DocField(value = "结算计量单位",required = true)
    private String settleUnit;

    @DocField(value = "加价率")
    private Double markUpRate;

    @DocField("计划id")
    private String planId;

    @DocField("计划明细id")
    private String planItemId;

    @DocField(value = "计划编号")
    private String planNo;

    @DocField(value = "计划明细编号")
    private String planItemNo;

    @DocField(value = "税金")
    private String taxPrice;

    @DocField(value = "税率")
    private String tax;

    @DocField(value = "协议经办人id（配送专责），协议商品必传")
    private String proDeliveryId;

    @DocField(value = "协议经办人名字（配送专责），协议商品必传")
    private String proDeliveryName;

    @DocField(value = "协议id")
    private String agreementId;

    @DocField(value = "协议编号")
    private String agreementNo;

    @DocField("协议模式 1：平台协议 2：单位协议")
    private String agreementCode;

    @DocField("协议bo，协议商品必传（根据协议id是否为空来判断）")
    private UocCreateOrderServiceReqAgrBo agrBo;

    @DocField(value = "sku物料编码")
    private String skuMaterialId;

    @DocField(value = "sku外部单品id")
    private String skuExtSkuId;

    @DocField(value = "sku品牌id")
    private Long skuBrandId;

    @DocField(value = "单品品牌名称")
    private String skuBrandName;

    @DocField(value = "sku明细id")
    private String skuItemId;

    @DocField(value = "sku物料名称")
    private String skuMaterialName;

    @DocField(value = "sku物料类型名称")
    private String skuMaterialTypeName;

    @DocField(value = "sku物料类型id")
    private String skuMaterialTypeId;

    @DocField(value = "型号")
    private String model;

    @DocField(value = "规格")
    private String spec;

    @DocField(value = "材质")
    private String texture;

    @DocField(value = "图号")
    private String figure;

    @DocField(value = "一级类目")
    private Long l1catalog;

    @DocField(value = "二级类目")
    private Long l2catalog;

    @DocField(value = "三级类目")
    private Long l3catalog;

    @DocField(value = "一级类目名称")
    private String l1catalogName;

    @DocField(value = "二级类目名称")
    private String l2catalogName;

    @DocField(value = "三级类目名称")
    private String l3catalogName;

    @DocField(value = "退货时间，空代表不支持")
    private Integer rejectAllowDate;

    @DocField(value = "换货时间，空代表不支持")
    private Integer exchangeAllowDate;

    @DocField(value = "维修时间，空代表不支持")
    private Integer maintainAllowDate;

    @DocField(value = "sku单品主图url")
    private String skuMainPicUrl;

    @DocField("商品json字符串，商品查询回原样数据，订单保存，以备未来使用")
    private String commJsonStr;

    @DocField("商品延保信息")
    private List<UocCreateOrderServiceReqItemEwBo> ewList;

    @DocField("订单明细纵向扩展数据")
    private List<UocBaseExtParallelBo> saleItemParallelExtList;

    //商品编码
    @DocField("商品编码")
    private String commodityCode;

    @DocField(value = "比选单号")
    private String cmpOrderNo;

    @DocField(value = "比选备注")
    private String cmpRemark;

}


