package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtCrossBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/13 20:38
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocOrderSubjectUpdateServiceReqBo extends BaseUmcReqBo {

    private static final long serialVersionUID = -1550317013267442498L;

    @DocField(value = "订单id",required = true)
    private Long orderId;

    @DocField(value = "父订单id")
    private Long upperOrderId;

    @DocField(value = "订单编码")
    private String orderNo;

    @DocField(value = "外部订单编码")
    private String orderNoExt;

    @DocField(value = "支付类型")
    private Integer payMod;

    @DocField(value = "支付方式")
    private String payType;

    @DocField(value = "支付状态")
    private String payState;

    @DocField(value = "订单状态")
    private String orderState;

    @DocField(value = "流转状态")
    private String procState;

    @DocField(value = "订单说明")
    private String orderDesc;

    @DocField(value = "销售金额")
    private BigDecimal totalSaleFee;

    @DocField(value = "采购金额")
    private BigDecimal totalPurchaseFee;

    @DocField(value = "优惠金额")
    private BigDecimal totalActShareFee;

    @DocField(value = "运费")
    private BigDecimal totalTransFee;

    @DocField(value = "实付金额")
    private BigDecimal usedFee;

    @DocField(value = "实付积分")
    private BigDecimal usedIntegral;

    @DocField(value = "竣工标志 1 竣工  0 在途")
    private Integer finishFlag;

    @DocField(value = "取消原因")
    private String cancelReason;

    @DocField(value = "备注")
    private String remark;

    @DocField("横向扩展参数")
    private UocBaseExtCrossBo extCrossBo;

    @DocField("纵向扩展数据")
    private List<UocOrderSubjectUpdateServiceReqExtParallelEditBo> parallelEditList;

    @DocField("更新附件")
    private List<UocOrderSubjectUpdateServiceReqAccessoryEditBo> accessoryList;

}


