package com.tydic.dyc.oc.service.order.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题：UocProOrderEffectiveInfoBo
 * 说明：订单时效类配置列表分页查询API 信息
 * 时间：2021/4/2 14:42
 * 作者 何秀全
 */
@Data
public class UocProOrderEffectiveInfoBo implements Serializable {
    private static final long serialVersionUID = 7019209603165847129L;
    /**
     * 时效配置ID 主键
     */
    @DocField("时效配置ID 主键")
    private Long effectiveId;
    /**
     * 时效配置编码
     * 1：电商预占库存时限；2：订单确认付款时限
     */
    @DocField("时效配置编码 1：电商预占库存时限；2：订单确认付款时限")
    private String effectiveCode;
    /**
     * 时效配置名称
     */
    @DocField("时效配置名称")
    private String effectiveName;
    /**
     * 业务类型编码
     */
    @DocField("业务类型编码")
    private String businessTypeCode;
    /**
     * 业务类型名称
     */
    @DocField("业务类型名称")
    private String businessTypeName;
    /**
     * 供应商编码
     */
    @DocField("供应商编码")
    private String supplierNo;
    /**
     * 供应商名称
     */
    @DocField("供应商名称")
    private String supplierName;
    /**
     * 时效 毫秒数
     */
    @DocField("时效 毫秒数")
    private Long aging;
    /**
     * 来源编码
     * 0：系统；1：自定义
     */
    @DocField("来源编码 0：系统；1：自定义")
    private String sourceCode;
    /**
     * 来源名称
     */
    @DocField("来源名称")
    private String sourceName;
    /**
     * 操作时间
     */
    @DocField("操作时间")
    private Date operatingTime;
    /**
     * 操作人ID
     */
    @DocField("操作人ID")
    private String operatorId;
    /**
     * 操作人名称
     */
    @DocField("操作人名称")
    private String operatorName;
}
