package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 标题：UocProOrderQuotaAllocationDealReqBo
 * 说明：订单下单限额配置处理API 入参
 * 时间：2021/4/2 17:00
 * 作者 何秀全
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocProOrderQuotaAllocationDealReqBo  extends BaseUmcReqBo {
    private static final long serialVersionUID = -1159781393470514309L;
    /**
     * ID主键(必填项)
     */
    @DocField("ID主键(必填项)")
    private Long confId;
    /**
     * 供应商ID
     */
    @DocField("供应商ID主键(必填项)")
    private Long supNo;
    /**
     * 供应商名称
     */
    @DocField("供应商名称")
    private String supplierName;
    /**
     * 订单超限额度
     */
    @DocField("订单超限额度")
    private BigDecimal orderQuota;
    /**
     * 业务类型编码
     */
    @DocField("业务类型编码")
    private String businessTypeCode;
    /**
     * 操作类型
     * 1：新增；2：修改；3：删除
     */
    @DocField("操作类型 1：新增；2：修改；3：删除")
    private Integer operateType;
}
