package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BasePageReqBo;
import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 标题：UocProOrderQuotaAllocationPageQueryReqBo
 * 说明：订单下单限额配置分页查询API 入参
 * 时间：2021/4/6 10:13
 * 作者 何秀全
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocProOrderQuotaAllocationPageQueryReqBo extends BasePageReqBo {
    private static final long serialVersionUID = 3064942120343820988L;
    /**
     * 业务类型编码
     */
    @DocField("业务类型编码")
    private String businessTypeCode;
    /**
     * 供应商ID
     */
    @DocField("供应商ID")
    private Long supNo;
    /**
     * 订单超限额度 开始
     */
    @DocField("订单超限额度 开始")
    private BigDecimal orderQuotaStart;
    /**
     * 订单超限额度 结束
     */
    @DocField("订单超限额度 结束")
    private BigDecimal orderQuotaEnd;
    /**
     * 操作时间 开始 格式：2021-04-06 09:51:42
     */
    @DocField("操作时间 开始 格式：2021-04-06 09:51:42")
    private String operatingTimeStart;
    /**
     * 操作时间 结束 格式：2021-04-06 09:51:42
     */
    @DocField("操作时间 结束 格式：2021-04-06 09:51:42")
    private String operatingTimeEnd;
    /**
     * 操作人名称
     */
    @DocField("操作人名称")
    private String operatorName;
}
