package com.tydic.dyc.oc.service.saleorder.bo;

import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelDeleteBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelEditBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocSaleOrderRefuseReqBo
 * 说明:销售单拒单 入参
 * 时间:2022/2/25 10:32
 * 作者:罗有
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class UocSaleOrderRefuseReqBo extends BaseUmcReqBo {
    private static final long serialVersionUID = -8572950541521182768L;

    @DocField(value = "操作 1接单 0拒单", required = true)
    private Integer opFlag;

    @DocField(value = "订单id", required = true)
    private Long orderId;

    @DocField(value = "销售单id", required = true)
    private Long saleOrderId;

    @DocField(value = "任务实例id", required = true)
    private String taskId;

    @DocField(value = "环节编码", required = true)
    private String stepId;

    @DocField(value = "拒单原因")
    private String rejectReason;

    @DocField(value = "拒单时间")
    private Date rejectTime;

    @DocField(value = "附件")
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryList;

    @DocField(value = "纵向扩展数据 更新")
    private List<UocBaseExtParallelEditBo> extEditList;

    @DocField(value = "纵向拓展信息 删除")
    private List<UocBaseExtParallelDeleteBo> extDeleteList;
}
