package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.oc.service.common.bo.UocBaseExtCrossBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/14 13:40
 */
@Data
public class UocGetOrderAllDetailServiceRspOrderCommInfoBo implements Serializable {

    private static final long serialVersionUID = -3959323768802083281L;

    @DocField(value = "订单id")
    private Long orderId;

    @DocField(value = "订单id")
    private Long saleOrderId;

    @DocField(value = "商品id")
    private String commodityId;

    @DocField(value = "商品名称")
    private String commodityName;

    @DocField(value = "商品类型ID")
    private String commodityTypeId;

    @DocField(value = "商品类型名称")
    private String commodityTypeName;

    @DocField(value = "外部单品ID")
    private String skuExtSkuId;

    @DocField(value = "单品ID")
    private String skuId;

    @DocField(value = "单品名称")
    private String skuName;

    @DocField(value = "供应商ID")
    private String supplierId;

    @DocField(value = "供应商名称")
    private String supplierName;

    @DocField(value = "店铺ID")
    private String supplierShopId;

    @DocField(value = "店铺名称")
    private String supplierShopName;

    @DocField(value = "采购价")
    private String purPrice;

    @DocField(value = "销售价")
    private String salePrice;

    @DocField(value = "创建时间")
    private Date createTime;

    @DocField(value = "创建工号")
    private String createOperId;

    @DocField(value = "更新时间")
    private Date updateTime;

    @DocField(value = "更新工号")
    private String updateOperId;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "供应商编码")
    private String supNo;

    @DocField(value = "供应商名称")
    private String supName;

    @DocField(value = "供应商账户名称")
    private String supAccountName;

    @DocField(value = "供应商账户")
    private String supAccount;

    @DocField(value = "供应商账户持有人编码")
    private String supAccountOwnId;

    @DocField(value = "供应商账户持有人名称")
    private String supAccountOwnName;

    @DocField(value = "供应商联系人")
    private String supRelaName;

    @DocField(value = "供应商联系电话")
    private String supRelaMobile;

    @DocField(value = "专业机构编码")
    private String proNo;

    @DocField(value = "专业机构名称")
    private String proName;

    @DocField(value = "专业机构账户")
    private String proAccountName;

    @DocField(value = "专业机构账户")
    private String proAccount;

    @DocField(value = "专业机构账户持有人编码")
    private String proAccountOwnId;

    @DocField(value = "专业机构账户持有人名称")
    private String proAccountOwnName;

    @DocField(value = "专业机构联系人")
    private String proRelaName;

    @DocField(value = "专业机构联系电话")
    private String proRelaMobile;

    @DocField(value = "专业机构配送员编码")
    private String proDeliveryId;

    @DocField(value = "专业机构配送员名称")
    private String proDeliveryName;

    @DocField(value = "订单明细id")
    private Long orderItemId;

    @DocField(value = "明细类型             1 商品sku             2 物资             3 项目")
    private Integer itemType;

    @DocField(value = "明细状态")
    private String orderItemState;

    @DocField(value = "采购金额")
    private BigDecimal purchasePrice;

    @DocField(value = "采购数量")
    private BigDecimal purchaseCount;

    @DocField(value = "运费")
    private BigDecimal transFee;

    @DocField("采购金额")
    private BigDecimal purchaseFee;

    @DocField("销售金额")
    private BigDecimal saleFee;

    @DocField(value = "应付金额")
    private BigDecimal payFee;

    @DocField(value = "积分优惠金额")
    private BigDecimal integralDisFee;

    @DocField(value = "活动优惠金额")
    private BigDecimal actDisFee;

    @DocField(value = "其它优惠金额")
    private BigDecimal otherDisFee;

    @DocField(value = "实付金额")
    private BigDecimal usedFee;

    @DocField(value = "实付积分")
    private BigDecimal usedIntegral;

    @DocField(value = "币种")
    private String currencyType;

    @DocField(value = "税金")
    private String taxPrice;

    @DocField(value = "税率")
    private String tax;

    @DocField(value = "预计发货时间")
    private Date preSendTime;

    @DocField(value = "预计交货时间")
    private Date preOfferTime;

    @DocField(value = "计量单位")
    private String unitName;

    @DocField(value = "结算计量单位")
    private String settleUnit;

    @DocField(value = "外部电商主订单id")
    private String imOrderId;

    @DocField(value = "外部电商子订单id")
    private String imSubOrderId;

    @DocField(value = "到货周期")
    private String arrivalTime;

    @DocField(value = "加价率")
    private Double markUpRate;

    @DocField(value = "商品服务费 ")
    private String serPrice;

    @DocField(value = "计划编号")
    private String planNo;

    @DocField(value = "计划明细编号")
    private String planItemNo;

    @DocField(value = "超验百分比，下单时保存（协议、无协议）")
    private Integer inspectionExcessPercent;

    @DocField(value = "税务编码")
    private String taxId;

    @DocField(value = "比选单号")
    private String cmpOrderNo;

    @DocField("订单明细横向扩展")
    private UocBaseExtCrossBo orderItemExtCrossBo;

    @DocField("订单明细纵向扩展")
    private List<UocBaseExtParallelBo> orderItemExtParallelBo;

    @DocField("三方横向扩展")
    private UocBaseExtCrossBo thirdExtCrossBo;

    @DocField("明细商品纵向扩展")
    private List<UocBaseExtParallelBo> commExtParallelBo;

    @DocField("订单详情延保信息")
    private List<UocGetOrderAllDetailServiceRspItemEwBo> itemEwBos;



}


