package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocQryOrderCreateResultServiceRspBo
 * 说明:
 * 时间:2022/2/22 10:47
 * 作者:田桂银
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocQryOrderCreateResultServiceRspBo extends BaseRspBo {

    private static final long serialVersionUID = 336495815737149815L;

    @DocField(value = "订单处理结果，返回true，代表后端数据处理完成（此时可以去读取successList和failedList），" +
            "如果返回false，可以继续轮询（轮询次数或者时间，由前端根据需求来定），直到返回true为止",required = true)
    private Boolean processResult;

    @DocField(value = "订单id",required = true)
    private Long orderId;

    @DocField("订单编号")
    private String orderNo;

    @DocField(value = "总销售金额",required = true)
    private BigDecimal totalSaleFee;

    @DocField(value = "需要审批的订单")
    private List<UocQryOrderCreateResultServiceRspProcessDataBo> needApprovedOrders = new ArrayList<>();

//    @DocField(value = "处理失败的订单，如果有失败，则代表整个订单有处理失败的订单，则需要展示相关原因")
    @DocField(value = "可以立即支付的订单")
    private List<UocQryOrderCreateResultServiceRspProcessDataBo> canPayOrders = new ArrayList<>();

}


