package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 标题：UocProOrderEffectiveAddAndModifyReqBo
 * 说明：订单时效类配置处理API 入参
 * 时间：2021/4/1 16:24
 * 作者 何秀全
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocProOrderEffectiveDealReqBo extends BaseUmcReqBo {
    private static final long serialVersionUID = 7675822062215675371L;
    /**
     * 时效配置ID 主键传入则是修改和删除
     */
    @DocField("时效配置ID 主键传入则是修改和删除")
    private Long effectiveId;
    /**
     * 时效配置编码
     */
    @DocField("时效配置编码")
    private String effectiveCode;
    /**
     * 业务类型编码
     */
    @DocField("业务类型编码")
    private String businessTypeCode;
    /**
     * 供应商编码
     */
    @DocField("供应商编码")
    private String supplierNo;
    /**
     * 供应商名称
     */
    @DocField("供应商名称")
    private String supplierName;
    /**
     * 时效 毫秒数
     */
    @DocField("时效 毫秒数")
    private Long aging;
    /**
     * 来源编码
     */
    @DocField("来源编码")
    private String sourceCode;
    /**
     * 是否删除
     */
    @DocField("是否删除")
    private Boolean isDelete;
}
