package com.tydic.dyc.oc.service.shiporder.bo;

import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelDeleteBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelEditBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocShipOrderArrivaRegistReqBo
 * 说明:发货单到货登记 入参
 * 时间:2022/2/25 10:08
 * 作者:罗有
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class UocShipOrderArrivaRegistReqBo extends BaseUmcReqBo {
    private static final long serialVersionUID = 6555174172876532041L;

    @DocField(value = "操作 1 到货确认 2到货拒收", required = true)
    private Integer opFlag = 1;

    @DocField(value = "订单id", required = true)
    private Long orderId;

    @DocField(value = "销售单id", required = true)
    private Long saleOrderId;

    @DocField(value = "发货单ID List", required = true)
    private List<Long> shipOrderIdList;

    @DocField(value = "到货备注")
    private String arriveRemark;

    @DocField(value = "收货人")
    private String receiverUser;

    @DocField(value = "收货备注")
    private String receiverRemark;

    @DocField(value = "收货联系电话")
    private String receiverContact;

    @DocField(value = "收货时间")
    private Date receiverTime;

    @DocField(value = "附件")
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryList;

    @DocField(value = "纵向扩展数据 更新")
    private List<UocBaseExtParallelEditBo> extEditList;

    @DocField(value = "纵向拓展信息 删除")
    private List<UocBaseExtParallelDeleteBo> extDeleteList;

    @DocField(value = "任务id")
    private String taskId;
}
