package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocAfOrderRefundDetailBo
 * 说明:退款明细信息
 * 时间:2022/2/14 13:46
 * 作者:tkl
 */

@Data
public class UocAfOrderRefundDetailBo implements Serializable {
    private static final long serialVersionUID = 2528398982216802173L;

    @DocField(value = "支付单id")
    private Long payOrderId;

    @DocField(value = "流水号")
    private String outPayOrderNo;

    @DocField(value = "售后金额")
    private BigDecimal payFee;

    @DocField(value = "退款金额")
    private BigDecimal realReturnFee;

    @DocField(value = "退款账户id")
    private String purAccount;

    @DocField(value = "退款账户名称")
    private String purAccountName;

    @DocField(value = "退款标志  0 扣款  1 退款")
    private Integer interType;

    @DocField(value = "退款标志翻译")
    private String interTypeStr;

    @DocField(value = "退款状态")
    private String payState;

    @DocField(value = "退款状态翻译")
    private String payStateStr;

    @DocField(value = "支付方式  1 微信  2 支付宝  3 企业支付")
    private Integer payType;

    @DocField(value = "支付方式翻译")
    private String payTypeStr;

    @DocField(value = "时间")
    private Date createTime;
}
