package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocAfOrderCommodityItemBo
 * 说明:售后单商品明细信息
 * 时间:2022/2/14 13:46
 * 作者:tkl
 */

@Data
public class UocAfOrderCommodityItemBo implements Serializable {
    private static final long serialVersionUID = 4144683818587785831L;

    @DocField(value = "售后服务单id")
    private Long afOrderId;

    @DocField(value = "服务明细id")
    private Long afOrderItemId;

    @DocField(value = "订单明细id")
    private Long orderItemId;

    @DocField(value = "售后中数量")
    private BigDecimal afterServingCount;

    @DocField(value = "已退货数量")
    private BigDecimal alreadyReturnCount;

    @DocField(value = "验收明细id")
    private Long inspOrderItemId;

    @DocField(value = "验收数量")
    private BigDecimal inspCount;

    @DocField(value = "发货单id")
    private Long shipOrderId;

    @DocField(value = "发货单编码")
    private String shipOrderNo;

    @DocField(value = "发货明细id")
    private Long shipOrderItemId;

    @DocField(value = "发货工号")
    private String shipOperId;

    @DocField(value = "发货联系人姓名")
    private String shipName;

    @DocField(value = "发货联系人电话")
    private String shipPhone;

    @DocField(value = "发货单状态")
    private String shipOrderState;

    @DocField(value = "发货单状态翻译")
    private String shipOrderStateStr;

    @DocField(value = "发货时间")
    private Date shipTime;

    @DocField(value = "单品ID")
    private String skuId;

    @DocField("单品名称")
    private String skuName;

    @DocField(value = "供应商ID")
    private String supplierId;

    @DocField(value = "店铺ID")
    private String supplierShopId;

    @DocField(value = "sku物料编码")
    private String skuMaterialId;

    @DocField(value = "sku物料名称")
    private String skuMaterialName;

    @DocField(value = "sku物料类型id")
    private String skuMaterialTypeId;

    @DocField(value = "sku物料类型名称")
    private String skuMaterialTypeName;

    @DocField(value = "sku单品主图url")
    private String skuMainPicUrl;

    @DocField(value = "sku来源")
    private Integer skuSource;

    @DocField(value = "sku来源翻译")
    private String skuSourceStr;

    @DocField(value = "销售价格")
    private BigDecimal salePrice;

    @DocField(value = "税率")
    private String tax;

    @DocField(value = "计量单位")
    private String unitName;

    @DocField(value = "采购数量")
    private BigDecimal purchaseCount;

    @DocField(value = "发货数量")
    private BigDecimal sendCount;

    @DocField(value = "采购名称")
    private String purName;

    @DocField(value = "销售退款金额")
    private BigDecimal retSaleFee;

    @DocField(value = "采购退款金额")
    private BigDecimal retPurchaseFee;

    @DocField(value = "售后数量")
    private BigDecimal returnCount;

    @DocField(value = "可售后数量")
    private BigDecimal availableAfterServCount;

    @DocField(value = "销售单id")
    private Long saleOrderId;

    @DocField(value = "采购金额")
    private BigDecimal purchasePrice;

    @DocField(value = "物流单号")
    private String shipCompanyNo;
}
