package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 标题：UocOrderRelUpdateReqBo
 * 说明：订单关联更新入参
 * 时间：2022/4/1 14:52
 *
 * @author 文乐
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class UocOrderRelUpdateReqBo extends BaseUmcReqBo {
    private static final long serialVersionUID = 2559543926041399980L;

    @DocField(value = "订单id", required = true)
    private Long orderId;

    @DocField(value = "对象ID", required = true)
    private Long objId;

    @DocField(value = "对象类型 1.订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单  8验收单  9审批单 10变更单   99.其他", required = true)
    private Integer objType;

    @DocField(value = "关联类型 0普通开票 1上游开票 2服务费", required = false)
    private Integer relType;

    @DocField(value = "关联状态 0未提交 1已提交 2挂起", required = false)
    private Integer relState;

    @DocField(value = "账期结束时间")
    private Date accountDayEndTime;

    @DocField(value = "付款时间")
    private Date payTime;

    @DocField(value = "付款状态")
    private String payState;

    @DocField(value = "关联ID", required = false)
    private String relId;

}
