package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocImplShipOrderReqBo
 * 说明:执行单发货 入参
 * 时间:2022/2/22 14:23
 * 作者:罗有
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class UocSaleShipOrderReqBo extends BaseUmcReqBo {
    private static final long serialVersionUID = -5637207939037461261L;

    @DocField(value = "订单ID", required = true)
    private Long orderId;

    @DocField(value = "销售单ID", required = true)
    private Long saleOrderId;

    @DocField(value = "环节编码", required = true)
    private String tacheCode;

    @DocField(value = "发货单类型")
    private Integer shipOrderType;

    @DocField(value = "物流公司id")
    private String shipCompanyId;

    @DocField(value = "物流公司名称")
    private String shipCompanyName;

    @DocField(value = "物流单号")
    private String shipCompanyNo;

    @DocField(value = "车牌号")
    private String carNo;

    @DocField(value = "运输方式")
    private Integer transportMode;

    @DocField(value = "发货时间")
    private Date shipTime;

    @DocField(value = "发货联系人姓名")
    private String shipName;

    @DocField(value = "发货联系人电话")
    private String shipPhone;

    @DocField(value = "预计到货时间")
    private Date estimateArrivalTime;

    @DocField(value = "发货备注")
    private String shipRemark;

    @DocField(value = "纵向扩展数据")
    private List<UocBaseExtParallelBo> extParallelBoList;

    @DocField(value = "发货明细", required = true)
    private List<UocSaleShipOrderReqItemBo> shipOrderItemBoList;
    
    @DocField(value = "附件")
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;
}
