package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 标题：类名称:UocAfterOrderCreateReqBo
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/1 14:22
 * 作者 @author 尹栋梁
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class UocAfterOrderCreateReqBo extends BaseReqBo {
    private static final long serialVersionUID = -7070282953681938211L;

    /**
     * 发货单ID
     */
    private Long shipOrderId;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 销售单ID
     */
    private Long saleOrderId;

    /**
     * 订单来源
     */
    private Integer orderSource;

    /**
     * 外部售后单Id
     */
    private String serviceId;

    /**
     * 服务类型 退货(10)、换货(20)、维修(30)
     */
    private Integer servType;

    /**
     * 售后原因
     */
    private Integer afsReason;

    /**
     * 取货服务类型  1： 上门取件 2：客户发货 3： 客户送货
     */
    private Integer pickwareType;

    /**
     * 取件地址 pickwareType=1必填
     */
    private UocAfterOrderCreateReqAddressBo takeAddress;

    /**
     * 返件地址 servType=20/30必填
     */
    private UocAfterOrderCreateReqAddressBo returnAddress;

    /**
     * 问题描述
     */
    private String questionDesc;

    /**
     * 售后明细
     */
    private List<UocAfterOrderCreateReqItemBo> shipItemList;

    /**
     * 纵向扩展数据
     */
    private List<UocBaseExtParallelBo> extParallelBoList;

    /**
     * 附件
     */
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;

    /**
     * 取货开始时间
     */
    private Date pickupStartTime;

    /**
     * 取货结束时间
     */
    private Date pickupEndTime;

    /**
     * 客户姓名
     */
    private String clientName;

    /**
     * 手机号
     */
    private String clientPhone;

    private Long userId;
    private String name;
    private String username;
    private Long orgId;
    private String orgName;
    private Long companyId;
    private String companyName;
    private String cellphone;

}
