package com.tydic.dyc.oc.service.domainservice.bo;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 标题:UocArrvalAcceptanceReqBo
 * 说明:验收单到货验收
 * 时间:2022/2/22 17:17
 * 作者:罗有
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class UocArrvalAcceptanceReqBo extends BaseReqBo {
    private static final long serialVersionUID = 6089201864274947760L;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 销售单ID
     */
    private Long saleOrderId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 其它备注
     */
    private String otherRemark;

    /**
     * 任务ID
     */
    private String taskId;

    /**
     * 环节编码
     */
    private String stepId;

    /**
     * 关闭尾差 true是 false否
     */
    private Boolean closePennyDiff;

    /**
     * 验收完结 true是 false否
     */
    private Boolean inspFinish;

    /**
     * 纵向扩展数据
     */
    private List<UocBaseExtParallelBo> extParallelBoList;

    /**
     * 发货信息
     */
    private List<UocCreateInspOrderReqShipBo> shipOrderList;

    /**
     * 附件
     */
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;

    /**
     * 业务外参数
     */
    private JSONObject jsonObj;

    private Long userId;
    private Long orgId;
    private String name;
    private String tenantId;
    private String cellphone;
    private Long supId;

}
