package com.tydic.dyc.oc.service.implorder.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/13 22:10
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocGetImplOrderKeyDetailsServiceRspBo extends BaseRspBo {

    private static final long serialVersionUID = 5681422419101424997L;


    /**
     * 销售单id
     */
    private Long saleOrderId;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 执行单编码
     */
    private String implOrderNo;

    /**
     * 外部执行单编码
     */
    private String implOrderNoExt;

    /**
     * 执行单名称
     */
    private String implOrderName;

    /**
     * 执行单类型
     */
    private Integer implOrderType;

    /**
     * 执行单状态
     */
    private String implOrderState;

    /**
     * 执行单说明
     */
    private String implOrderDesc;

    /**
     * 销售金额
     */
    private BigDecimal totalSaleFee;

    /**
     * 采购金额
     */
    private BigDecimal totalPurchaseFee;

    /**
     * 优惠金额
     */
    private BigDecimal totalActShareFee;

    /**
     * 运费
     */
    private BigDecimal totalTransFee;

    /**
     * 实付金额
     */
    private BigDecimal usedFee;

    /**
     * 实付积分
     */
    private BigDecimal usedIntegral;

    /**
     * 协议编号
     */
    private String agreementNo;

    /**
     * 合同编号
     */
    private String contractNo;

    /**
     * 流转状态
     */
    private String procState;

    /**
     * 对账状态
     */
    private String checkState;

    /**
     * 税率
     */
    private String taxRate;

    /**
     * 竣工标志 1 竣工  0 在途
     */
    private Integer finishFlag;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建工号
     */
    private String createOperId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新工号
     */
    private String updateOperId;

    /**
     * 撤单时间
     */
    private Date cancelTime;

    /**
     * 撤单工号
     */
    private String cancelOperId;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 备注
     */
    private String remark;

    /**
     * 竣工时间
     */
    private Date finishTime;

    /**
     * 逾期时间
     */
    private Date expTime;

    /**
     * 结算模式 2:撮合 1:贸易
     */
    private Integer modelSettle;

    /**
     * 采购类别  1 物资     2 施工     3 服务
     */
    private Integer purchaseType;

    /**
     * 扩展字段1
     */
    private String extField1;

    /**
     * 扩展字段2
     */
    private String extField2;

    /**
     * 扩展字段3
     */
    private String extField3;

    /**
     * 扩展字段4
     */
    private String extField4;

    /**
     * 扩展字段5
     */
    private String extField5;

    /**
     * 扩展字段6
     */
    private String extField6;

    /**
     * 扩展字段7
     */
    private String extField7;

    /**
     * 扩展字段8
     */
    private String extField8;

    /**
     * 扩展字段9
     */
    private String extField9;

    /**
     * 扩展字段10
     */
    private String extField10;
}


