package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 标题：UocProOrderEvaluateDealReqBo
 * 说明：订单评价配置处理API 入参
 * 时间：2021/4/6 14:56
 * 作者 何秀全
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocProOrderEvaluateDealReqBo extends BaseReqBo {

	private static final long serialVersionUID = -1577502679538823913L;

	/**
	 * 评价ID 传入即是修改
	 */
	private Long evaluateId;

	/**
	 * 应用单位编码
	 */
	private String applicationUnitNo;

	/**
	 * 应用单位名称
	 */
	private String applicationUnitName;

	/**
	 * 评价截止时间 毫秒数
	 */
	private Long evaluationDeadline;

	/**
	 * 系统自动好评状态：0：否；1：是
	 */
	private Integer systemAutomaticPraise;

	/**
	 * 是否允许追评：0：否；1：是
	 */
	private Integer whetherReview;

	/**
	 * 追评截止时间 毫秒数
	 */
	private Long reviewDeadline;

	/**
	 * 是否删除
	 */
	private Boolean isDelete;

	/**
	 * 用户ID
	 */
	private Long userId;

	/**
	 * 账户名
	 */
	private String username;
}
