package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtCrossBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/13 20:38
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocOrderSubjectUpdateServiceReqBo extends BaseReqBo {

    private static final long serialVersionUID = -1550317013267442498L;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 父订单id
     */
    private Long upperOrderId;

    /**
     * 订单编码
     */
    private String orderNo;

    /**
     * 外部订单编码
     */
    private String orderNoExt;

    /**
     * 支付类型
     */
    private Integer payMod;

    /**
     * 支付方式
     */
    private String payType;

    /**
     * 支付状态
     */
    private String payState;

    /**
     * 订单状态
     */
    private String orderState;

    /**
     * 流转状态
     */
    private String procState;

    /**
     * 订单说明
     */
    private String orderDesc;

    /**
     * 销售金额
     */
    private BigDecimal totalSaleFee;

    /**
     * 采购金额
     */
    private BigDecimal totalPurchaseFee;

    /**
     * 优惠金额
     */
    private BigDecimal totalActShareFee;

    /**
     * 运费
     */
    private BigDecimal totalTransFee;

    /**
     * 实付金额
     */
    private BigDecimal usedFee;

    /**
     * 实付积分
     */
    private BigDecimal usedIntegral;

    /**
     * 竣工标志 1 竣工  0 在途
     */
    private Integer finishFlag;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 备注
     */
    private String remark;

    /**
     * 横向扩展参数
     */
    private UocBaseExtCrossBo extCrossBo;

    /**
     * 纵向扩展数据
     */
    private List<UocOrderSubjectUpdateServiceReqExtParallelEditBo> parallelEditList;

    /**
     * 更新附件
     */
    private List<UocOrderSubjectUpdateServiceReqAccessoryEditBo> accessoryList;

}


