package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 描述: 〈支付配置信息〉
 * @author : yuhao
 * @date : 2022/7/21 15:25
 */
@Data
public class UocSaleOrderPayConfQryServiceRspConfBo implements Serializable {

    private static final long serialVersionUID = 1531551272230777173L;

    @DocField(value = "付款方式 0 预付款按比例支付,1 按协议约束支付,2 按账期支付")
    private Integer payType;

    @DocField(value = "预付款(比例)")
    private BigDecimal prePaySup;

    @DocField(value = "到货款(比例)")
    private BigDecimal verPaySup;

    @DocField(value = "验收款(比例)")
    private BigDecimal pilPaySup;

    @DocField(value = "质保金(比例)")
    private BigDecimal quaPaySup;

    @DocField(value = "预付款")
    private BigDecimal prePayFee;

    @DocField(value = "到货款")
    private BigDecimal verPayFee;

    @DocField(value = "验收款")
    private BigDecimal pilPayFee;

    @DocField(value = "质保金")
    private BigDecimal quaPayFee;

    @DocField(value = "预付款-已付")
    private BigDecimal prePayedFee;

    @DocField(value = "到货款-已付")
    private BigDecimal verPayedFee;

    @DocField(value = "验收款-已付")
    private BigDecimal pilPayedFee;

    @DocField(value = "质保金-已付")
    private BigDecimal quaPayedFee;

    @DocField(value = "账期天数")
    private Integer paymentDays;

    @DocField(value = "指定账期日")
    private Integer payAccountDay;

    @DocField(value = "使用类型：1：采购方；2：平台方")
    private Integer userType;

    @DocField(value = "账期支付结算规则 1:指定账期日 2:账期起算特定业务节点+账期天数")
    private Integer payRule;

    @DocField(value = "账期日结算订单规则 1:签收发票开始 2:订单验收 3:订单到货")
    private Integer payAccountDayRule;

    @DocField(value = "账期起算特定业务节点 1:签收发票开始计算 2:订单验收开始计算 3:订单到货开始计算")
    private Integer payNodeRule;

    @DocField(value = "违约金额比例")
    private BigDecimal payBreakScale;

    @DocField(value = "合同ID")
    private String modelContractId;

}


