package com.tydic.dyc.oc.service.implorder.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocGetImplOrderDetailsServiceRspItemBo
 * 说明:执行单明细信息
 * 时间:2022/2/14 14:24
 * 作者:罗有
 */

@Data
public class UocGetImplOrderDetailsServiceRspItemBo implements Serializable {
    private static final long serialVersionUID = -8009710685725649658L;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 销售单id
     */
    private Long saleOrderId;

    /**
     * 执行明细id
     */
    private Long implOrderItemId;

    /**
     * 销售明细id
     */
    private Long saleOrderItemId;


    /**
     * 明细状态
     */
    private String implItemState;

    /**
     * 明细状态翻译
     */
    private String implItemStateStr;

    /**
     * 明细类型             1 商品sku             2 物资             3 项目
     */
    private Integer itemType;

    /**
     * 明细类型翻译
     */
    private String itemTypeStr;

    /**
     * 单品ID
     */
    private String skuId;

    /**
     * 单品名称
     */
    private String skuName;

    /**
     * 商品名称
     */
    private String commodityName;

    /**
     * 商品ID
     */
    private String commodityId;

    /**
     * 供应商ID
     */
    private String supplierId;

    /**
     * 店铺ID
     */
    private String supplierShopId;

    /**
     * 计量单位
     */
    private String unitName;

    /**
     * 结算计量单位
     */
    private String settleUnit;

    /**
     * 采购金额
     */
    private BigDecimal purchaseFee;

    /**
     * 销售金额
     */
    private BigDecimal saleFee;

    /**
     * 应付金额
     */
    private BigDecimal payFee;

    /**
     * 运费
     */
    private BigDecimal transFee;

    /**
     * 积分优惠金额
     */
    private BigDecimal integralDisFee;

    /**
     * 活动优惠金额
     */
    private BigDecimal actDisFee;

    /**
     * 其它优惠金额
     */
    private BigDecimal otherDisFee;

    /**
     * 实付金额
     */
    private BigDecimal usedFee;

    /**
     * 实付积分
     */
    private BigDecimal usedIntegral;

    /**
     * 币种
     */
    private String currencyType;

    /**
     * 税金
     */
    private String taxPrice;

    /**
     * 税率
     */
    private String tax;

    /**
     * 税务编码
     */
    private String taxId;

    /**
     * 采购数量
     */
    private BigDecimal purchaseCount;
    /**
     * 发货数量
     */
    private BigDecimal sendCount;

    /**
     * 到货数量
     */
    private BigDecimal arriveCount;

    /**
     * 拒收数量
     */
    private BigDecimal refuseCount;

    /**
     * 退货数量
     */
    private BigDecimal returnCount;

    /**
     * 验收数量
     */
    private BigDecimal acceptanceCount;

    /**
     * 售后在途数量
     */
    private BigDecimal afterServingCount;

    /**
     * 超验百分比，下单时保存（协议、无协议）
     */
    private Integer inspectionExcessPercent;

    /**
     * 采购金额
     */
    private BigDecimal purchasePrice;

    /**
     * 销售金额
     */
    private BigDecimal salePrice;

    /**
     * sku物料编码
     */
    private String skuMaterialId;

    /**
     * sku外部单品id
     */
    private String skuExtSkuId;

    /**
     * sku品牌id
     */
    private Long skuBrandId;

    /**
     * 单品品牌名称
     */
    private String skuBrandName;

    /**
     * sku明细id
     */
    private String skuItemId;

    /**
     * sku物料名称
     */
    private String skuMaterialName;

    /**
     * sku物料类型名称
     */
    private String skuMaterialTypeName;

    /**
     * sku物料类型id
     */
    private String skuMaterialTypeId;

    /**
     * 型号
     */
    private String model;

    /**
     * 规格
     */
    private String spec;

    /**
     * 材质
     */
    private String texture;

    /**
     * 图号
     */
    private String figure;

    /**
     * 一级类目
     */
    private Long l1Catalog;

    /**
     * 二级类目
     */
    private Long l2Catalog;

    /**
     * 三级类目
     */
    private Long l3Catalog;

    /**
     * 一级类目名称
     */
    private String l1CatalogName;

    /**
     * 二级类目名称
     */
    private String l2CatalogName;

    /**
     * 三级类目名称
     */
    private String l3CatalogName;

    /**
     * sku单品主图url
     */
    private String skuMainPicUrl;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建工号
     */
    private String createOperId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新工号
     */
    private String updateOperId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 执行单明细拓展信息
     */
    private List<UocGetImplOrderDetailsServiceRspItemExtBo> implOrderDetailsServiceRspItemExtBoList;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;
}
