package com.tydic.dyc.oc.service.domainservice.bo;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 描述: 〈领域服务-到货验收入参〉
 * @author : yuhao
 * @date : 2022/8/26 16:38
 */
@Data
public class UocArrvalAcceptanceReqBo extends BaseReqBo {
    private static final long serialVersionUID = 6089201864274947760L;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 销售单ID
     */
    private Long saleOrderId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 其它备注
     */
    private String otherRemark;

    /**
     * 任务ID
     */
    private String taskId;

    /**
     * 环节编码
     */
    private String stepId;

    /**
     * 关闭尾差 true是 false否
     */
    private Boolean closePennyDiff;

    /**
     * 验收完结 true是 false否
     */
    private Boolean inspFinish;

    /**
     * 纵向扩展数据
     */
    private List<UocBaseExtParallelBo> extParallelBoList;

    /**
     * 发货信息
     */
    private List<UocCreateInspOrderReqShipBo> shipOrderList;

    /**
     * 附件
     */
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;

    /**
     * 业务外参数
     */
    private JSONObject jsonObj;
    /**
     * 当前登录人id
     */
    private Long userId;
    /**
     * 当前登录人机构
     */
    private Long orgId;
    /**
     * 当前登录人名称
     */
    private String name;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 联系电话
     */
    private String cellphone;
    /**
     * 供应商id
     */
    private Long supId;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;

}
