package com.tydic.dyc.oc.service.order.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题：UocProOrderEvaluateInfoBo
 * 说明：订单评价配置分页查询API 数据信息
 * 时间：2021/4/6 17:31
 * 作者 何秀全
 */
@Data
public class UocProOrderEvaluateInfoBo implements Serializable {
	private static final long serialVersionUID = 8612431543343240057L;
	/**
	 * 评价ID 主键
	 */
	@DocField("评价ID 主键")
	private Long evaluateId;
	/**
	 * 应用单位编码
	 */
	@DocField("应用单位编码")
	private String applicationUnitNo;
	/**
	 * 应用单位名称
	 */
	@DocField("应用单位名称")
	private String applicationUnitName;
	/**
	 * 评价截止时间 毫秒数
	 */
	@DocField("评价截止时间 毫秒数")
	private Long evaluationDeadline;
	/**
	 * 系统自动好评状态：0：否；1：是
	 */
	@DocField("系统自动好评状态：0：否；1：是")
	private Integer systemAutomaticPraise;
	/**
	 * 是否允许追评：0：否；1：是
	 */
	@DocField("是否允许追评：0：否；1：是")
	private Integer whetherReview;
	/**
	 * 追评截止时间 毫秒数
	 */
	@DocField("追评截止时间 毫秒数")
	private Long reviewDeadline;
	/**
	 * 操作时间
	 */
	@DocField("操作时间")
	private Date operatingTime;
	/**
	 * 操作人ID
	 */
	@DocField("操作人ID")
	private String operatorId;
	/**
	 * 操作人名称
	 */
	@DocField("操作人名称")
	private String operatorName;

	/**
	 * 租户id
	 */
	private Long sysTenantId;
	private String sysTenantName;
}
